% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_diet_fat.R
\name{adj_diet_fat}
\alias{adj_diet_fat}
\title{Adjust diet composition estimates for prey fat content}
\usage{
adj_diet_fat(prey_fat, diet_est, diet_var = NA)
}
\arguments{
\item{prey_fat}{A numeric vector of the mean fatty acid mass for each prey
type.}

\item{diet_est}{A numeric vector or matrix of the estimated diet
composition(s) of individual predator(s) or predator type(s). Intended to
be the object \code{est_ind} or \code{est_mean}returned by the function
\code{\link{est_diet}}.}

\item{diet_var}{A numeric matrix or array containing the estimated variance
matrix for the estimated diet(s) of individual predator(s) or predator
type(s). Intended to be the object \code{var_ind} or \code{var_mean)}
returned by the function \code{\link{est_diet}}. Optional.}
}
\value{
A list containing the following elements: \describe{
  \item{diet_est}{A numeric vector or matrix of the estimated diet
    composition of individual predator(s) or predator type(s) in terms of
    the scale represented by \code{prey_fat}.}
  \item{diet_var}{A numeric matrix or array containing the estimated variance
    matrix for the estimated diet of individual predator(s) or predator
    type(s), in terms of the scale represented by \code{prey_fat}.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
  }
}
\description{
The function \code{est_diet} estimates diet composition in terms of the
mass of fatty acids consumed. The function \code{adj_diet_fat} uses
estimates of fatty acid mass per prey type to transform estimates of diet
composition in terms of fatty acid mass to another scale.
}
\section{Details}{

The function \code{est_diet} estimates diet composition in terms of the
mass of fatty acids consumed. Such estimates may be of direct ecological
interest, especially for ecosystems in which lipids are particularly
important. In other cases, one may wish to transform estimates to a different
scale. For example, if the units of \code{prey_fat} are (fatty acid mass)/
(animal mass), the function \code{adj_diet_fat} returns diet composition
estimates in terms of the relative prey mass consumed. Alternatively, if the
units of \code{prey_fat} are (fatty acid mass)/(animal), the function
\code{adj_diet_fat} returns diet composition estimates in terms of the
relative numbers of prey animals consumed.

\code{adj_diet_fat} uses the fat transformation of Iverson et al. (2004).
Variance matrices are estimated using the delta method (Seber 1982).

NOTE: values of mass per prey type are treated as known constants without
variance.
}

\section{References}{

Iverson, S.J., C. Field, W.D. Bowen, and W. Blanchard. 2004.
  Quantitative fatty acid signature analysis: A new method of
  estimating predator diets. \emph{Ecological Monographs} 74:211-235.

Seber, G.A.F. 1982. The Estimation of Animal Abundance and Related
  Parameters, second edition. Macmillan Publishing Co., New York.
}

\examples{
adj_diet_fat(prey_fat = c(0.5, 1, 2),
             diet_est = c(0.3, 0.2, 0.5),
             diet_var = matrix(c( 0.030,  0.004, -0.003,
                                 0.004,  0.025, -0.007,
                                -0.003, -0.007,  0.045),
                               nrow = 3, ncol = 3))

adj_diet_fat(prey_fat = c(0.5, 1, 2),
             diet_est = c(0.3, 0.2, 0.5))

}
