% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_sig.R
\name{prep_sig}
\alias{prep_sig}
\title{Prepare fatty acid signature data for analysis}
\usage{
prep_sig(df_sig, fa_names, use_fa, zero_rep = 75, scale = 3)
}
\arguments{
\item{df_sig}{A data frame containing prey fatty acid signature data.
\code{qfasar} has strict formatting requirements for \code{df_sig}; please
see Details and/or the vignette.}

\item{fa_names}{A character vector of all fatty acid names.}

\item{use_fa}{A logical vector defining a fatty acid suite.}

\item{zero_rep}{A constant associated with the method and value to replace
signature proportions that are missing or less than or equal to 0. Default
value 75.}

\item{scale}{An integer indicator of the desired scaling option. Default
value 3.}
}
\value{
A list containing the following elements: \describe{
  \item{type}{A character vector of the type of each signature.}
  \item{id}{A character vector of the unique sample ID of each signature.}
  \item{n_types}{The number of unique types.}
  \item{uniq_types}{A character vector of the unique types, sorted
    alphanumerically.}
  \item{n_sig}{The total number of signatures.}
  \item{type_ss}{The number of signatures for each unique \code{type}.}
  \item{loc}{A vector or matrix giving the first and last locations of the
    signatures of each \code{type}, after being sorted by \code{type} and
    \code{id}.}
  \item{sig_rep}{A vector or matrix of the original signatures, with any
    values missing or less than or equal to 0 replaced, in column-major
    format.}
  \item{n_fa_rep}{The number of fatty acids in \code{sig_rep}.}
  \item{sig_scale}{A vector or matrix of scaled signatures ready for
    analysis, sorted by \code{type} and \code{id}, in column-major format.}
  \item{n_fa_suite}{The number of fatty acids in \code{sig_scale}.}
  \item{fa_suite}{A character vector of the names of fatty acids in the suite
    to be used in the analysis.}
  \item{zero_rep_val}{A constant associated with the method and value to be
    used to replace proportions that are missing or less than or equal to 0.
    See Details.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
  }
}
\description{
The function \code{prep_sig} prepares raw fatty acid signatures for
analysis.  Signature proportions that are missing, negative, or equal to zero
are replaced with a small user-specified constant and the signatures are
scaled to sum to 1.0. The fatty acids that are not to be used in the analysis
are censored and the signatures are scaled using one of three options
(Bromaghin et al. In press).
}
\section{Details}{

This function is designed to be called by the user to prepare fatty acid
signatures for analysis.  For most analyses, \code{prep_sig} should be
called immediately after the fatty acid suites and fatty acid signatures have
been read into data frames, and after the fatty acid suites data frame has
been processed by the function \code{prep_fa}.  Please refer to the
vignette for additional information.

The data frame with fatty acid signatures must meet the following formatting
requirements:
  \itemize{
  \item The file must be in row-major format, i.e., each row contains the
    information for an individual animal.
  \item The first column must contain a designation of animal \code{type}.
    For prey data, \code{type} often denotes species.  For predator data,
    \code{type} denotes classes of predators for which separate estimates of
    mean diet composition are desired.
  \item The second column must contain an identifier unique to each
    signature, i.e. a sample ID.
  \item The remaining columns must contain fatty acid signature proportions
    or percentages.
  \item The data frame must contain a header record, with a name for each
    column, such as "type", "id", name of fatty acid 1, name of fatty
    acid 2, ...
  \item The file should contain data from all available fatty acids, rather
    than a subset.  The fatty acid suite to be used in the analysis is
    defined by the argument \code{fa}.
  }

Please refer to the documentation for the utility function
\code{\link{sig_rep_zero}} for information regarding the argument
\code{zero_rep}.

Please refer to the documentation for the utility function
\code{\link{sig_scale}} for information regarding the argument
\code{scale}.
}

\section{References}{

Bromaghin, J.F., S.M. Budge, and G.W. Thiemann. In press. Should fatty
  acid signature proportions sum to 1 for diet estimation?
  \emph{Ecological Research}.

Iverson, S.J., C. Field, W.D. Bowen, and W. Blanchard. 2004.
  Quantitative fatty acid signature analysis: A new method of
  estimating predator diets. \emph{Ecological Monographs} 74:211-235.
}

\examples{
prep_sig(df_sig = data.frame(type = c("Type_1", "Type_1", "Type_2",
                                      "Type_2"),
                             id = c("ID_1", "ID_2", "ID_3", "ID_4"),
                             fa_1 = c(0.0, 0.2, 0.3, 0.6),
                             fa_2 = c(0.1, 0.3, 0.3, 0.4),
                             fa_3 = c(0.9, 0.5, 0.4, NA),
                             row.names = c("Prey_1", "Prey_2", "Prey_3",
                                           "Prey_4")),
         fa_names = c("fa_1", "fa_2", "fa_3"),
         use_fa = c(TRUE, FALSE, TRUE),
         zero_rep = 0.0001,
         scale=2)

prep_sig(df_sig = data.frame(type = c("Type_1", "Type_1", "Type_2",
                                      "Type_2"),
                             id = c("ID_1", "ID_2", "ID_3", "ID_4"),
                             fa_1 = c(0.0, 0.2, 0.3, 0.6),
                             fa_2 = c(0.1, 0.3, 0.3, 0.4),
                             fa_3 = c(0.9, 0.5, 0.4, NA),
                             row.names = c("Prey_1", "Prey_2", "Prey_3",
                                           "Prey_4")),
         fa_names = c("fa_1", "fa_2", "fa_3"),
         use_fa = c(TRUE, FALSE, TRUE),
         zero_rep = 90,
         scale=1)

prep_sig(df_sig = data.frame(type = c("Type_1", "Type_1", "Type_2",
                                      "Type_2"),
                             id = c("ID_1", "ID_2", "ID_3", "ID_4"),
                             fa_1 = c(0.0, 0.2, 0.3, 0.6),
                             fa_2 = c(0.1, 0.3, 0.3, 0.4),
                             fa_3 = c(0.9, 0.5, 0.4, NA),
                             row.names = c("Prey_1", "Prey_2", "Prey_3",
                                           "Prey_4")),
         fa_names = c("fa_1", "fa_2", "fa_3"),
         use_fa = c(TRUE, FALSE, TRUE),
         scale=3)

prep_sig(df_sig = data.frame(type = c("Type_1", "Type_1", "Type_2",
                                      "Type_2"),
                             id = c("ID_1", "ID_2", "ID_3", "ID_4"),
                             fa_1 = c(0.0, 0.2, 0.3, 0.6),
                             fa_2 = c(0.1, 0.3, 0.3, 0.4),
                             fa_3 = c(0.9, 0.5, 0.4, NA),
                             row.names = c("Prey_1", "Prey_2", "Prey_3",
                                           "Prey_4")),
         fa_names = c("fa_1", "fa_2", "fa_3"),
         use_fa = c(TRUE, FALSE, TRUE))

}
