library(shinytest2)

test_that("{shinytest2} recording: qrlabelr", {
  app <- AppDriver$new(name = "qrlabelr", height = 704, width = 1235)
  app$set_inputs(toplt_state = FALSE)
  app$set_inputs(toprt_state = FALSE)
  app$set_inputs(centrt_state = FALSE)
  app$set_inputs(botlt_state = FALSE)
  app$expect_values()
  app$upload_file(datUploader = "square_lattice.csv")
  app$set_inputs(from_fieldhub = TRUE)
  app$set_inputs(preview_dat = TRUE)
  app$click("submit_dat")
  app$click("npg1")
  app$set_inputs(IBlock = TRUE)
  app$set_inputs(seed_source = TRUE)
  app$set_inputs(seed = "SEED_SOURCE")
  app$set_inputs(rname = "AWK")
  app$click("gen_qrcode")
  app$click("npg2")
  app$set_inputs(templates_open = TRUE, allow_no_input_binding_ = TRUE)
  app$set_inputs(templates_open = FALSE, allow_no_input_binding_ = TRUE)
  app$click("npg3")
  app$click("npg4")
  app$set_inputs(family_open = TRUE, allow_no_input_binding_ = TRUE)
  app$set_inputs(family = "mono")
  app$set_inputs(family_open = FALSE, allow_no_input_binding_ = TRUE)
  app$set_inputs(family_open = TRUE, allow_no_input_binding_ = TRUE)
  app$set_inputs(family = "sans")
  app$set_inputs(family_open = FALSE, allow_no_input_binding_ = TRUE)
  app$set_inputs(font_size = 9)
  app$set_inputs(font_size = 10)
  app$set_inputs(font_size = 11)
  app$set_inputs(font_size = 10)
  app$set_inputs(lab_sel = 2)
  app$set_inputs(lab_sel = 1)
  app$click("npg5")
  app$set_inputs(all_labels = TRUE)
  app$click("gen_labels")
})
