% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/characteristicPolynomial.R
\name{characteristicPolynomial}
\alias{characteristicPolynomial}
\title{Characteristic polynomial}
\usage{
characteristicPolynomial(A)
}
\arguments{
\item{A}{a square matrix with numeric, character, or \code{bigq} entries}
}
\value{
A univariate \code{qspray} polynomial.
}
\description{
Characteristic polynomial of a matrix.
}
\examples{
set.seed(666)
A <- matrix(rpois(9L, 10), nrow = 3, ncol = 3)
( P <- characteristicPolynomial(A) )
# check the roots are the eigen values:
f <- as.function(P, N = TRUE)
sapply(eigen(A)$values, f) # approx c(0, 0, 0)
}
