% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh.R
\name{file_exists_remote}
\alias{file_exists_remote}
\title{Checks if a local or remote file exists.}
\usage{
file_exists_remote(file, remote = FALSE, verbose = FALSE)
}
\arguments{
\item{file}{File path.}

\item{remote}{Remote machine specification for ssh, in format such as \code{user@server} that does not
require interactive password entry. For local execution, pass \code{FALSE} (default). For
execution on the default qsub config remote, use \code{TRUE}.}

\item{verbose}{If \code{TRUE} prints the command.}
}
\value{
\code{TRUE} or \code{FALSE} indicating whether the file exists.
}
\description{
Checks if a local or remote file exists.
}
\examples{
\dontrun{
file_exists_remote("~/myfile.csv", remote = "me@myserver")
# [1] TRUE
}
}
