% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtl2-package.R
\docType{package}
\name{qtl2-package}
\alias{qtl2}
\alias{qtl2-package}
\title{qtl2: Quantitative Trait Locus Mapping in Experimental Crosses}
\description{
Provides a set of tools to perform quantitative trait locus (QTL) analysis in experimental crosses. It is a reimplementation of the 'R/qtl' package to better handle high-dimensional data and complex cross designs. Broman et al. (2019) \doi{10.1534/genetics.118.301595}.
}
\section{Vignettes}{

\itemize{
\item \href{https://kbroman.org/qtl2/assets/vignettes/user_guide.html}{user guide}
\item \href{https://kbroman.org/qtl2/pages/rqtl2_functions.html}{categorized list of functions in R/qtl2}
\item \href{https://kbroman.org/qtl2/assets/vignettes/input_files.html}{input file formats}
\item \href{https://kbroman.org/qtl2/assets/vignettes/qtl2fst.html}{using qtl2fst for on-disk genotype probabilities}
\item \href{https://kbroman.org/qtl2/pages/prep_do_data.html}{preparing DO mouse data for R/qtl2}
\item \href{https://kbroman.org/qtl2/assets/vignettes/do_diagnostics.html}{genotype diagnostics for diversity outbred mice}
\item \href{https://kbroman.org/qtl2/assets/vignettes/do_mixups.html}{identifying sample mix-ups in diversity outbred mice}
\item \href{https://kbroman.org/qtl2/assets/vignettes/rqtl_diff.html}{differences between R/qtl and R/qtl2}
\item \href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{developer guide}
\item \href{https://smcclatchy.github.io/mapping/}{Tutorial on R/qtl2} by
\href{https://github.com/smcclatchy}{Susan McClatchy} and \href{https://github.com/dmgatti}{Dan Gatti}
}
}

\section{Related packages}{

\itemize{
\item \href{https://github.com/rqtl/qtl2convert}{qtl2convert}, for converting
data among the R/qtl2, DOQTL, and R/qtl formats
\item \href{https://github.com/rqtl/qtl2fst}{qtl2fst}, for storing genotype
probabilities on disk
\item \href{https://github.com/byandell-sysgen/qtl2ggplot}{qtl2ggplot},
for \href{https://ggplot2.tidyverse.org/}{ggplot2}-based data visualizations
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://kbroman.org/qtl2/}
  \item \url{https://github.com/rqtl/qtl2}
  \item Report bugs at \url{https://github.com/rqtl/qtl2/issues}
}

}
\author{
\strong{Maintainer}: Karl W Broman \email{broman@wisc.edu} (\href{https://orcid.org/0000-0002-4914-6671}{ORCID})

Other contributors:
\itemize{
  \item R Core Team [contributor]
}

}
\keyword{internal}
