% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_calc_genoprob.R
\name{subset.calc_genoprob}
\alias{subset.calc_genoprob}
\alias{[.calc_genoprob}
\title{Subsetting genotype probabilities}
\usage{
\method{subset}{calc_genoprob}(x, ind = NULL, chr = NULL, ...)

\method{[}{calc_genoprob}(x, ind = NULL, chr = NULL)
}
\arguments{
\item{x}{Genotype probabilities as output from \code{\link[=calc_genoprob]{calc_genoprob()}}.}

\item{ind}{A vector of individuals: numeric indices, logical
values, or character string IDs}

\item{chr}{A vector of chromosomes: logical values, or character
string IDs. Numbers are interpreted as character string IDs.}

\item{...}{Ignored.}
}
\value{
An object of class \code{"calc_genoprob"}, like the input, with the selected
individuals and/or chromsomes; see \code{\link[=calc_genoprob]{calc_genoprob()}}.
}
\description{
Pull out a specified set of individuals and/or chromosomes from
the results of \code{\link[=calc_genoprob]{calc_genoprob()}}.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
\dontshow{grav2 <- grav2[1:8,c(1,2)]}
pr <- calc_genoprob(grav2)
# keep just individuals 1:5, chromosome 2
prsub <- pr[1:5,2]
# keep just chromosome 2
prsub2 <- pr[,2]
}
\keyword{utilities}
