% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genoprob_to_alleleprob_fst.R
\name{genoprob_to_alleleprob_fst}
\alias{genoprob_to_alleleprob_fst}
\title{Convert genotype probabilities to allele probabilities and write to fst database}
\usage{
genoprob_to_alleleprob_fst(
  probs,
  fbase,
  fdir = ".",
  quiet = TRUE,
  cores = 1,
  compress = 0,
  overwrite = FALSE
)
}
\arguments{
\item{probs}{Genotype probabilities, as calculated from
\code{\link[qtl2:calc_genoprob]{qtl2::calc_genoprob()}}.}

\item{fbase}{Base of filename for fst database.}

\item{fdir}{Directory for fst database.}

\item{quiet}{IF \code{FALSE}, print progress messages.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}

\item{compress}{Amount of compression to use (value in the range 0-100; lower values mean larger file sizes)}

\item{overwrite}{If FALSE (the default), refuse to overwrite any files that already exist.}
}
\value{
Link to fst database for the \code{probs} input with probabilities
collapsed to alleles rather than genotypes.
}
\description{
Reduce genotype probabilities (as calculated by
\code{\link[qtl2:calc_genoprob]{qtl2::calc_genoprob()}}) to allele probabilities, writing them to an fst database.
}
\details{
This is like calling \code{qtl2::genoprob_to_alleleprob()} and then
\code{fst_genoprob()}, but in a way that hopefully saves memory by
doing it one chromosome at a time.
}
\examples{
library(qtl2)
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
gmap_w_pmar <- insert_pseudomarkers(iron$gmap, step=1)

# genotype probabilities
fst_dir <- file.path(tempdir(), "iron_genoprob")
dir.create(fst_dir)
probs_fst <- calc_genoprob_fst(iron, "iron", fst_dir, gmap_w_pmar, error_prob=0.002)

# allele probabilities
fst_dir_apr <- file.path(tempdir(), "iron_alleleprob")
dir.create(fst_dir_apr)
aprobs_fst <- genoprob_to_alleleprob_fst(probs_fst, "iron", fst_dir_apr)

# clean up: remove all the files we created
unlink(fst_files(probs_fst))
unlink(fst_files(aprobs_fst))
}
\seealso{
\code{\link[qtl2:genoprob_to_alleleprob]{qtl2::genoprob_to_alleleprob()}}, \code{\link[=fst_genoprob]{fst_genoprob()}}
}
\keyword{utilities}
