% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind_fst_genoprob.R
\name{rbind.fst_genoprob}
\alias{rbind.fst_genoprob}
\title{Join genotype probabilities for different individuals}
\usage{
\method{rbind}{fst_genoprob}(..., fbase = NULL, fdir = NULL, overwrite = FALSE, quiet = FALSE)
}
\arguments{
\item{...}{Genotype probability objects as produced by
\code{\link[=fst_genoprob]{fst_genoprob()}}. Must have the same set of markers and
genotypes.}

\item{fbase}{Base of fileame for fst database.
Needed if objects have different fst databases.}

\item{fdir}{Directory for fst database.}

\item{overwrite}{If FALSE (the default), refuse to overwrite existing \code{.fst} files}

\item{quiet}{If TRUE, don't show any messages. Passed to \code{\link[=fst_genoprob]{fst_genoprob()}}.}
}
\value{
A single genotype probability object.
}
\description{
Join multiple genotype probability objects, as produced by
\code{\link[=fst_genoprob]{fst_genoprob()}} for different individuals.
}
\examples{
library(qtl2)
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map <- insert_pseudomarkers(grav2$gmap, step=1)
probsA <- calc_genoprob(grav2[1:5,], map, error_prob=0.002)
probsB <- calc_genoprob(grav2[6:12,], map, error_prob=0.002)
dir <- tempdir()
fprobsA <- fst_genoprob(probsA, "exampleAr", dir, overwrite=TRUE)
fprobsB <- fst_genoprob(probsB, "exampleBr", dir, overwrite=TRUE)

# use rbind to combine probabilities for same chromosomes but different individuals
fprobs <- rbind(fprobsA, fprobsB, fbase = "exampleABr")

# clean up: remove all the files we created
unlink(fst_files(fprobsA))
unlink(fst_files(fprobsB))
unlink(fst_files(fprobs))

}
\seealso{
\code{\link[=cbind.fst_genoprob]{cbind.fst_genoprob()}}
}
