% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_and_format_files.R
\name{missing_combinations}
\alias{missing_combinations}
\title{Detect dates and hours missing in filenames}
\usage{
missing_combinations(data, hour_col = "hour", date_col = "day")
}
\arguments{
\item{data}{A data.frame with one column for the raster's date
and another for the hour. If not explicitly specified
in the function's arguments, the column names are \code{day} and \code{hour}.}

\item{hour_col}{The name of the column with the hour information.}

\item{date_col}{The name of the column with the date information.}
}
\value{
A data.frame with the missing days and hours, if any.
}
\description{
Facebook mobility data is reported daily at 3 different hours
(0, 8, 16).
This function reads the data extracted from the current files and detects
if any file for a particular day or hour is missing.
}
\examples{

# Sample dataset
data <- data.frame(
  country = c("US", "MX", "MX"), 
  day = c("2023-01-01", "2023-01-03", "2023-01-05"),
  hour = c(0, 8, 16)
)

missing_combinations(data)
}
