% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spin.R
\name{add_spin_preamble}
\alias{add_spin_preamble}
\title{Add spin preamble to R script}
\usage{
add_spin_preamble(script, title = NULL, preamble = NULL, quiet = FALSE)
}
\arguments{
\item{script}{Path to the R script file}

\item{title}{Custom title for the preamble. If provided, overrides any title
in the \code{preamble} list. If NULL, uses \code{preamble$title} or filename as fallback.}

\item{preamble}{Named list of YAML metadata to include in preamble.
The \code{title} parameter takes precedence over \code{preamble$title} if both are provided.}

\item{quiet}{If \code{TRUE}, suppresses messages and warnings.}
}
\value{
Invisibly returns the script path if modified, otherwise invisible NULL
}
\description{
Adds a minimal spin preamble to an R script file if one doesn't already exist.
The preamble includes a title derived from the filename and is formatted as
a YAML block suitable preprended with \verb{#'} for \code{\link[knitr:spin]{knitr::spin()}}.
}
\details{
This is useful to prepare R scripts for use with
Quarto Script rendering support.
See \url{https://quarto.org/docs/computations/render-scripts.html#knitr}
}
\section{Preamble format}{

For a script named \code{analysis.R}, the function adds this preamble by default:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#' ---
#' title: analysis
#' ---
#'

# Original script content starts here
}\if{html}{\out{</div>}}

This is the minimal preamble required for Quarto Script rendering, so that
\href{https://quarto.org/docs/computations/execution-options.html#engine-binding}{Engine Bindings} works.
}

\examples{
\dontrun{
# Basic usage with default title
add_spin_preamble("analysis.R")

# Custom title
add_spin_preamble("analysis.R", title = "My Analysis")

# Custom preamble with multiple fields
add_spin_preamble("analysis.R", preamble = list(
  title = "Advanced Analysis",
  author = "John Doe",
  date = Sys.Date(),
  format = "html"
))

# Title parameter overrides preamble title
add_spin_preamble("analysis.R",
  title = "Final Title",  # This takes precedence
  preamble = list(
    title = "Ignored Title",
    author = "John Doe"
  )
)
}
}
