% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/rd.R
\name{m_add_box}
\alias{m_add_box}
\alias{m_add_curve}
\alias{m_add_anyShape}
\title{Create and add shape}
\usage{
m_add_box(id, spec = list())

m_add_curve(id, spec = list())
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{spec}{Shape style specification.}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Create and add shape
}
\examples{
library(r3dmol)

# Add arrow
r3dmol() \%>\%
  m_add_arrow(
    start = m_vector3(-10, 0, 0),
    end = m_vector3(0, -10, 0),
    radius = 1,
    radiusRatio = 1,
    mid = 1,
    spec = m_shape_spec(
      clickable = TRUE,
      callback =
        "function() {
            this.color.setHex(0xFF0000FF);
            viewer.render()
          }"
    )
  )

# Add curve
r3dmol() \%>\%
  m_add_curve(
    spec = list(
      points = list(
        m_vector3(0, 0, 0),
        m_vector3(5, 3, 0),
        m_vector3(5, 7, 0),
        m_vector3(0, 10, 0)
      ),
      radius = 0.5,
      smooth = 10,
      fromArrow = FALSE,
      toArrow = TRUE,
      color = "orange"
    )
  )

# Add cylinder
r3dmol() \%>\%
  m_add_cylinder(
    start = list(x = 0.0, y = 0.0, z = 0.0),
    end = list(x = 10.0, y = 0.0, z = 0.0),
    radius = 1.0,
    fromCap = 1,
    toCap = 2,
    spec = m_shape_spec(
      color = "red",
      hoverable = TRUE,
      clickable = TRUE,
      callback = "
        function() {
          this.color.setHex(0x00FFFF00);
          viewer.render();
        }",
      hover_callback = "
        function() {
          viewer.render();
        }",
      unhover_callback = "
        function() {
          this.color.setHex(0xFF000000);
          viewer.render();
        }"
    )
  )

# Add line
r3dmol() \%>\%
  m_add_line(
    dashed = TRUE,
    start = m_vector3(0, 0, 0),
    end = m_vector3(30, 30, 30)
  )

# Add box
r3dmol() \%>\%
  m_add_box(spec = list(
    center = m_vector3(0, 5, 0),
    demensions = list(w = 3, h = 4, d = 2),
    color = "magenta"
  ))

# Add sphere
r3dmol() \%>\%
  m_add_sphere(
    center = m_vector3(0, 0, 0),
    radius = 10,
    spec = m_shape_spec(color = "red")
  )
}
