% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_boot_samples_list.R
\name{gen_boot_samples_list}
\alias{gen_boot_samples_list}
\title{Bootstrapped resampling}
\usage{
gen_boot_samples_list(lineup_list, bootno)
}
\arguments{
\item{lineup_list}{A list containing k vectors of lineup choices for k lineups,
in which the target was either absent or present}

\item{bootno}{Number of bootstrap samples}
}
\value{
A list of bootstrapped lineup data
        Length of list = no. of boostrap sample draws
}
\description{
Function for generating bootstrapped samples for of k vectors of lineup choices
}
\examples{
#Data:
A <-  round(runif(100,1,6))
B <-  round(runif(70,1,5))
C <-  round(runif(20,1,4))
linelist <- list(A, B, C)
rm(A, B, C)

bootno <- 1000

#Call:
bootdata <- gen_boot_samples_list(linelist, bootno)

}
