% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.2_Factorial_designs_Classes.R
\name{desOpt}
\alias{desOpt}
\title{desOpt-class: Class `desOpt`}
\description{
The \code{desOpt} class represents an object that stores optimization results for factorial design experiments. It includes coded and real factors, responses, desirabilities, overall desirability, and the design object.
}
\seealso{
\code{\link{optimum}}, \code{\link{facDesign}}, \code{\link{desirability}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{facCoded}}{A list containing the coded values for the factors in the design.}

\item{\code{facReal}}{A list containing the real (actual) values for the factors in the design.}

\item{\code{responses}}{A list of response variables obtained from the design.}

\item{\code{desirabilities}}{A list of desirability scores for each response variable.}

\item{\code{overall}}{Numeric value representing the overall desirability score.}

\item{\code{all}}{A data frame containing all the relevant data from the design and optimization process.}

\item{\code{fdo}}{The factorial design object used in the optimization process.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-desOpt-as.data.frame}{\code{desOpt$as.data.frame()}}
\item \href{#method-desOpt-print}{\code{desOpt$print()}}
\item \href{#method-desOpt-clone}{\code{desOpt$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-desOpt-as.data.frame"></a>}}
\if{latex}{\out{\hypertarget{method-desOpt-as.data.frame}{}}}
\subsection{Method \code{as.data.frame()}}{
Convert the object to a data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{desOpt$as.data.frame()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-desOpt-print"></a>}}
\if{latex}{\out{\hypertarget{method-desOpt-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{desOpt$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-desOpt-clone"></a>}}
\if{latex}{\out{\hypertarget{method-desOpt-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{desOpt$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
