% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_dpq_distributions_adSim.R
\name{qweibull3}
\alias{qweibull3}
\title{qweibull3: The Weibull Distribution (3 Parameter)}
\usage{
qweibull3(p, shape, scale, threshold, ...)
}
\arguments{
\item{p}{A numeric vector of probabilities.}

\item{shape}{The shape parameter of the Weibull distribution. Default is 1.}

\item{scale}{The scale parameter of the Weibull distribution. Default is 1.}

\item{threshold}{The threshold (or location) parameter of the Weibull distribution. Default is 0.}

\item{...}{Additional arguments passed to \code{uniroot} for \code{qweibull3}.}
}
\value{
\code{dweibull3} returns the density, \code{pweibull3} returns the distribution function, and \code{qweibull3} returns the quantile function for the Weibull distribution with a threshold.
}
\description{
Density function, distribution function, and quantile function for the Weibull distribution with a threshold parameter.
}
\details{
The Weibull distribution with the \code{scale} parameter alpha, \code{shape} parameter c, and \code{threshold} parameter zeta has a density function given by:
\deqn{f(x) = \frac{c}{\alpha} \left(\frac{x - \zeta}{\alpha}\right)^{c-1} \exp\left(-\left(\frac{x - \zeta}{\alpha}\right)^c\right)}

The cumulative distribution function is given by:
\deqn{F(x) = 1 - \exp\left(-\left(\frac{x - \zeta}{\alpha}\right)^c\right)}
}
\examples{
dweibull3(x = 1, scale = 1, shape = 5, threshold = 0)
temp <- pweibull3(q = 1, scale = 1, shape = 5, threshold = 0)
temp
qweibull3(p = temp, scale = 1, shape = 5, threshold = 0)
}
