% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunogenicity_functions.R
\name{mixedModel}
\alias{mixedModel}
\title{Mixed model wrapper for assay dataframe}
\usage{
mixedModel(assay.df.melted, var = c("Operator", "Day"))
}
\arguments{
\item{assay.df.melted}{A data.frame produced by assayMelt()}

\item{var}{Variable to look at. Either "Day" or "Operator".}
}
\value{
A data.frame with the following columns: "Parameter", "Estimate", "LowerCI", "UpperCI", "Tstat"
}
\description{
This function is a wrapper for the lmer() function to produce a table of results. Here, the sample ID is included as a random intercept effect, then the results of the fixed effect model estimates are reported together with 95\% confidence intervals and t statistics.
}
\examples{
assay.df.melted <- assayMelt(assay.df = lognormAssay, exp.name = 'Experiment1')
mixedModel(assay.df.melted, var = 'Day')

}
\author{
Emma Gail

Lidija Turkovic
}
