% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{rAmCharts4-shiny}
\alias{rAmCharts4-shiny}
\alias{amChart4Output}
\alias{renderAmChart4}
\title{Shiny bindings for using \code{rAmCharts4} in Shiny}
\usage{
amChart4Output(outputId, width = "100\%", height = "400px")

renderAmChart4(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended}

\item{expr}{an expression that generates a chart with
\code{\link{amBarChart}}, \code{\link{amHorizontalBarChart}},
\code{\link{amLineChart}}, \code{\link{amScatterChart}},
\code{\link{amRangeAreaChart}}, \code{\link{amRadialBarChart}},
\code{\link{amDumbbellChart}}, \code{\link{amHorizontalDumbbellChart}},
\code{\link{amGaugeChart}}, \code{\link{amPieChart}}, or
\code{\link{amPercentageBarChart}}}

\item{env}{the environment in which to evaluate \code{expr}}

\item{quoted}{whether \code{expr} is a quoted expression}
}
\description{
Output and render functions for using the \code{rAmCharts4}
  widgets within Shiny applications and interactive Rmd documents.
}
\examples{
library(rAmCharts4)
library(shiny)
library(lubridate)

ui <- fluidPage(
  br(),
  fluidRow(
    column(
      width = 8,
      amChart4Output("linechart", height = "500px")
    ),
    column(
      width = 4,
      tags$fieldset(
        tags$legend("Chart data"),
        verbatimTextOutput("chartData"),
      ),
      tags$fieldset(
        tags$legend("Change"),
        verbatimTextOutput("chartChange")
      )
    )
  )
)

server <- function(input, output){

  set.seed(666)
  dat <- data.frame(
    date = ymd(180101) + months(0:11),
    visits = rpois(12, 20),
    x = 1:12
  )

  output[["linechart"]] <- renderAmChart4({
    amLineChart(
      data = dat,
      data2 = dat,
      xValue = "date",
      yValues = "visits",
      draggable = TRUE,
      chartTitle = amText(
        text = "Number of visits",
        color = "crimson",
        fontWeight = "bold",
        fontFamily = "cursive"
      ),
      xAxis = list(
        title = "Date",
        labels = amAxisLabels(rotation = -45),
        breaks = amAxisBreaks(timeInterval = "1 month")
      ),
      yAxis = "Visits",
      yLimits = c(0, 35),
      backgroundColor = "whitesmoke",
      tooltip = "[bold][font-style:italic]{dateX}[/]\nvisits: {valueY}[/]",
      Yformatter = "#",
      caption = amText(
        text = "[bold font-size:22]Year 2018[/]",
        color = "fuchsia"
      ),
      button = amButton(
        label = amText("Reset data", color = "black"),
        color = "seashell",
        position = 0.95
      ),
      theme = "dataviz")
  })

  output[["chartData"]] <- renderPrint({
    input[["linechart"]]
  })

  output[["chartChange"]] <- renderPrint({
    input[["linechart_change"]]
  })

}

if(interactive()) {
  shinyApp(ui, server)
}
}
