% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rIACI.R
\name{w90p}
\alias{w90p}
\title{Calculate W90p Index}
\usage{
w90p(ci, freq = c("monthly", "annual"))
}
\arguments{
\item{ci}{List. Climate input object created by \code{\link{climate_input}}.}

\item{freq}{Character. Frequency of calculation, either "monthly" or "annual".}
}
\value{
Data frame with dates and calculated W90p values.
}
\description{
Calculates the percentage of days when wind speed is above the 90th percentile.
}
\examples{
\donttest{
# 1. Generate a daily date sequence from 1960-01-01 to 2020-12-31
dates <- seq.Date(
  from = as.Date("1960-01-01"),
  to   = as.Date("2020-12-31"),
  by   = "day"
)

# 2. Create random weather data for each date
n <- length(dates)
tmax <- runif(n, min = 5, max = 40)
tmin <- runif(n, min = -10,  max = 5)
# Example: use a Poisson distribution to simulate precipitation
prec <- rpois(n, lambda = 2)
# Random wind speeds, e.g., 0 to 10 m/s
wind <- runif(n, min = 0, max = 10)

# 3. Construct the climate_input object
ci <- climate_input(
  tmax  = tmax,
  tmin  = tmin,
  prec  = prec,
  wind  = wind,
  dates = dates
)
# Then:
# 4. Calculate monthly W90p index
w90p_values <- w90p(ci, freq = "monthly")
}
}
