% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topsea.R
\name{topSEA}
\alias{topSEA}
\title{topSEA}
\usage{
topSEA(object, by, thresh = NULL, descending = TRUE, n = 20, cover)
}
\arguments{
\item{object}{A SEA-chart object which is the output of \code{SEA} function}

\item{by}{Variable name by which the ordering should happen. It should be a column of SEA-chart.
The default is TDP_bound.}

\item{thresh}{A real number between 0 and 1. If specified the values of the variable defined in \code{by}
will be threshold accordingly.}

\item{descending}{Logical. If \code{TRUE} The output chart is organized in a descending order}

\item{n}{Integer. Number of raws of the output chart}

\item{cover}{An optional threshold for coverage, which must be a real number between 0 and 1.
If specified, feature-sets with a coverage lower than or equal to this value are removed.}
}
\value{
Returns a subset of SEA_chart sorted according to the arguments
}
\description{
returns a permutation  of SEA-chart which rearranges
the feature-sets according to the selected argument into ascending or
descending order.
}
\examples{
#See the examples for \code{\link{SEA}}

}
\references{
Mitra Ebrahimpoor, Pietro Spitali, Kristina Hettne, Roula Tsonaka, Jelle Goeman,
Simultaneous Enrichment Analysis of all Possible Gene-sets: Unifying Self-Contained
and Competitive Methods, Briefings in Bioinformatics,bbz074
}
\seealso{
\code{\link{SEA}}
}
\author{
Mitra Ebrahimpoor

\email{m.ebrahimpoor@lumc.nl}
}
