% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{create_train_test_indices}
\alias{create_train_test_indices}
\title{Create train and test splits for cross-validation}
\usage{
create_train_test_indices(
  data_list,
  cv_type = c("k-fold", "loo", "lpo"),
  k = 5,
  percentage = 20,
  number_folds = 10
)
}
\arguments{
\item{data_list}{A list of datasets, one per likelihood. Each dataset can be a data.frame,
SpatialPointsDataFrame, or metric_graph_data object}

\item{cv_type}{Type of cross-validation: "k-fold", "loo", or "lpo". Default is "k-fold"}

\item{k}{Number of folds for k-fold CV. Default is 5}

\item{percentage}{Training data percentage for LPO CV (1-99). Default is 20}

\item{number_folds}{Number of folds for LPO CV. Default is 10}
}
\value{
A list where each element contains:
\item{train}{Indices for training data mapped to original datasets}
\item{test}{Indices for test data mapped to original datasets}
}
\description{
Creates train and test splits for cross-validation by handling multiple data types
and supporting k-fold, leave-one-out (LOO), and leave-percentage-out (LPO) methods.
Handles missing values and maintains data structure across multiple datasets.
}
\details{
The function handles NA values by removing rows with any missing values before
creating splits. For multiple datasets, indices are mapped back to their original
positions in each dataset.
}
