% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrinsic.R
\name{simulate.intrinsicCBrSPDEobj}
\alias{simulate.intrinsicCBrSPDEobj}
\title{Simulation of a fractional intrinsic SPDE using the
covariance-based rational SPDE approximation}
\usage{
\method{simulate}{intrinsicCBrSPDEobj}(
  object,
  nsim = 1,
  seed = NULL,
  kappa = NULL,
  tau = NULL,
  alpha = NULL,
  beta = NULL,
  integral.constraint = TRUE,
  use_kl = NULL,
  ...
)
}
\arguments{
\item{object}{The covariance-based rational SPDE approximation,
computed using \code{\link[=intrinsic.matern.operators]{intrinsic.matern.operators()}}}

\item{nsim}{The number of simulations.}

\item{seed}{An object specifying if and how the random number generator should be initialized (‘seeded’).}

\item{kappa}{new value of kappa to use}

\item{tau}{new value of tau to use}

\item{alpha}{new value of alpha to use}

\item{beta}{new value of beta to use}

\item{integral.constraint}{Should the contraint on the integral be done?}

\item{use_kl}{Simulate based on a KL expansion?}

\item{...}{Currently not used.}
}
\value{
A matrix with the \code{nsim} samples as columns.
}
\description{
The function samples a Gaussian random field based using the
covariance-based rational SPDE approximation.
}
