% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_keener.R
\name{keener}
\alias{keener}
\title{Keener's method for Rating and Ranking}
\usage{
keener(
  jpMat,
  method = "keener",
  irreducibility = 0.01,
  ties.method = "average"
)
}
\arguments{
\item{jpMat}{a Judge-Presenter matrix, or a User-Movie matrix}

\item{method}{a character string specifying Keener's method without applying a nonlinear skweing function, including "keener", "keenerwolrs"}

\item{irreducibility}{a non-negative parameter, which is the ratio of the value of each element in the pertubation matrix to the average value in the normalized proportaion matrix.}

\item{ties.method}{a character string specifying how ties are treated, including "average", "first", "last", "random", "max", "min", from base::rank}
}
\description{
Calculate ratings and provide rankings using Keener's method,  without using Laplace's Rule of Succession, and using Laplace's Rule of Succession
}
\details{
\enumerate{
\item \code{keener}: Keener's method with Laplace's Rule of Succession
\item \code{keenerwolrs}: Keener's method without Laplace's Rule of Succession
}

\enumerate{
\item \code{hitsjp}: HITS, using judge-presenter matrix, equivalent to \code{offdefsc}
\item \code{offdefnt}: Offense-Defense rating method, using judge-presenter matrix
}
}
\examples{
library(popdemo)
jpMat <- matrix(data=c(5,4,3,0, 5,5,3,1, 0,0,0,5, 0,0,2,0, 4,0,0,3, 1,0,0,4),
nrow=6,
byrow=TRUE)
result <- keener(jpMat,
method = 'keener',
irreducibility = 0)
print(result)
}
\references{
Gou, J. and Wu, S. (2020). A Judging System for Project Showcase: Rating and Ranking with Incomplete Information. Technical Report.

Keener, J. P. (1993). The Perron-Frobenius theorem and the ranking of football teams. SIAM Review 35, 80-93.

Langville, A. N. and Meyer, C. D. (2012). Who's Number 1?: The Science of Rating and Ranking. Princeton University Press.
}
\author{
Jiangtao Gou
}
