% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_markov.R
\name{markov}
\alias{markov}
\title{Google's PageRank algorithm for Rating and Ranking}
\usage{
markov(
  jpMat,
  method = "markovvl",
  dampingFactor = 0.85,
  ties.method = "average"
)
}
\arguments{
\item{jpMat}{a Judge-Presenter matrix, or a User-Movie matrix}

\item{method}{a character string specifying Markov's method, including "markov", "markovvl", "markovlvpd", "markovwlvp".}

\item{dampingFactor}{the PageRank theory holds that an imaginary surfer who is randomly clicking on links will eventually stop clicking. The probability, at any step, that the person will continue is a damping factor. Web 0.85, NFL 0.60, NCAA basketball 0.50}

\item{ties.method}{a character string specifying how ties are treated, including "average", "first", "last", "random", "max", "min", from base::rank}
}
\description{
Calculate ratings and provide rankings using Google's PageRank algorithm
}
\details{
\enumerate{
\item \code{markov}: Markov's method, voting with losses, equivalent to \code{markovvl}
\item \code{markovvl}: Markov's method, voting with losses
\item \code{markovlvpd}: Markov's method, losers vote with point differentials
\item \code{markovwlvp}: Markov's method, winners and losers vote with points
}
}
\examples{
jpMat <- matrix(data=c(5,4,3,0, 5,5,3,1, 0,0,0,5, 0,0,2,0, 4,0,0,3, 1,0,0,4),
nrow=6,
byrow=TRUE)
result <- markov(jpMat, 
method='markovvl', 
dampingFactor=0.85, 
ties.method='average')
print(result)
}
\references{
Brin, S. and Page, L. (1998). The anatomy of a large-scale hypertextual web search engine. Computer Networks and ISDN Systems 30, 107-117. Proceedings of the Seventh International World Wide Web Conference.

Gou, J. and Wu, S. (2020). A Judging System for Project Showcase: Rating and Ranking with Incomplete Information. Technical Report.

Langville, A. N. and Meyer, C. D. (2012). Who's Number 1?: The Science of Rating and Ranking. Princeton University Press.
}
\author{
Jiangtao Gou
}
