% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_linestring.R
\name{geo_linestring}
\alias{geo_linestring}
\title{Random GeoJSON linestring}
\usage{
geo_linestring(count = 1, num_vertices = 10, max_length = 0.001,
  max_rotation = pi/8, bbox = NULL)
}
\arguments{
\item{count}{(integer/numeric) number of Polygons. Default: 1}

\item{num_vertices}{(integer/numeric) how many coordinates each polygon will
contain. Default: 10}

\item{max_length}{(integer/numeric) maximum distance that a vertex can be
from its predecessor. Units are in degrees latitude (Approximately 69 miles
or 111 km). Default: 0.001 (approximately 121 yards or 111 meters)}

\item{max_rotation}{(integer/numeric) the maximum number of radians that a
line segment can turn from the previous segment. Default: pi / 8}

\item{bbox}{(integer/numeric) lat/long bounding box for the starting point of
the line, numeric vector of the form \code{west (long), south (lat), east
  (long), north (lat)}. optional}
}
\value{
GeoJSON; a list with one ore more Linestrings in a FeatureCollection,
with class \code{geo_list} - simple \code{unclass()} to remove the class
}
\description{
Random GeoJSON linestring
}
\examples{
geo_linestring()
geo_linestring(10)
geo_linestring(bbox = c(50, 50, 60, 60))
}
