% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installation.R
\name{generate_installation_order}
\alias{generate_installation_order}
\title{Create a Data Frame of The Resolved Result
This function exports the results from \code{\link[=resolve]{resolve()}} to a data frame, which each row represents one installation step. The order of rows is the installation order. By installing packages in the specified order, one can install all the resolved packages without conflicts.}
\usage{
generate_installation_order(rang)
}
\arguments{
\item{rang}{output from \code{\link[=resolve]{resolve()}}}
}
\value{
A data frame ordered by installation order.
}
\description{
Create a Data Frame of The Resolved Result
This function exports the results from \code{\link[=resolve]{resolve()}} to a data frame, which each row represents one installation step. The order of rows is the installation order. By installing packages in the specified order, one can install all the resolved packages without conflicts.
}
\examples{
\donttest{
if (interactive()) {
    graph <- resolve(pkgs = c("openNLP", "LDAvis", "topicmodels", "quanteda"),
                    snapshot_date = "2020-01-16")
    generate_installation_order(graph)
}
}
}
\references{
Ripley, B. (2005) \href{https://cran.r-project.org/doc/Rnews/Rnews_2005-1.pdf}{Packages and their Management in R 2.1.0.} R News, 5(1):8--11.
}
