% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractCorrelation.R
\name{extractCorrelation}
\alias{extractCorrelation}
\title{Extract the posterior distribution of evolutionary correlation}
\usage{
extractCorrelation(post)
}
\arguments{
\item{post}{a posterior distribution object as returned by the function 'readMCMC' or a merged posterior generated by 'mergePosterior'.}
}
\value{
a list with the posterior distribution of evolutionary correlations among traits. If the data is a 2x2 matrix then the object will be a matrix and each regime will be a column of this matrix.
}
\description{
Function extracts the posterior distribution of evolutionary correlation among traits.
}
\details{
Returns a list with length equal to the number of regimes. Each list element is composed by a matrix with trait correlation types in the columns and the evolutionary correlations for each sample at the rows. \cr
\cr
One can plot the correlation values using boxplots and compare their distribution. Pairwise statistical tests across the samples is also possible.
}
\examples{
\donttest{
data( centrarchidae )
handle <- ratematrixMCMC(data=centrarchidae$data, phy=centrarchidae$phy.map
                         , gen=10000, dir=tempdir())
posterior <- readMCMC(handle, burn = 0.2, thin = 1)
## Get the correlations:
cor.list <- extractCorrelation(post = posterior)
## Plot the results:
class( cor.list ) ## In this case we have a matrix.
boxplot(cor.list, names = c("Regime 1", "Regime 2"))
## Same example with more traits.
data( anoles )
handle <- ratematrixMCMC(data=anoles$data[,1:3], phy=anoles$phy
                         , gen=5000, dir=tempdir())
anole_post <- readMCMC(handle, burn = 0.2, thin = 1)
## Get the correlations:
cor.anole <- extractCorrelation(post = anole_post)
## Plot the results:
class( cor.anole ) ## In this case we have a list!
names( cor.anole ) ## Each element is a regime.
## We can plot the regimes in separate.
boxplot(cor.anole$island)
boxplot(cor.anole$mainland)
}
}
\author{
Daniel Caetano and Luke Harmon
}
