% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shops.R
\name{search_shops}
\alias{search_shops}
\title{Search shops}
\usage{
search_shops(query = NULL, shop_type_id = NULL, lat = NULL,
  lng = NULL, radius = NULL, units = NULL, page = NULL,
  page_size = NULL, sort = NULL)
}
\arguments{
\item{query}{search string}

\item{shop_type_id}{set to 1 to restrict to local stores only (filter out chains and online stores)}

\item{lat}{latitude for geographic search}

\item{lng}{longitude for geographic search}

\item{radius}{radius for geographic search}

\item{units}{units for geographic search, `miles` or `km`}

\item{page}{result page to retrieve; defaults to 1}

\item{page_size}{number of results to retrieve; defaults to 100}

\item{sort}{options: `best`, `added`, `favorites`}
}
\value{
tibble with address, social media, and other descriptive features for shops
}
\description{
This function retrieves shops based on search terms.
}
\examples{
\dontrun{search_shops(lat = 42.35, lng = -71.05, radius = 100)}

}
