% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{deserializeDataFrame}
\alias{deserializeDataFrame}
\title{Deserializes the given vector of raw bytes and returns a data.frame object.}
\usage{
deserializeDataFrame(bytes)
}
\arguments{
\item{bytes}{The vector of raw bytes to deserialize}
}
\value{
A data.frame object from the specified raw vector
}
\description{
The raw vector to be deserialized must represent a Raven DataFrame. That
DataFrame is returned as an R data.frame object.
}
\details{
The column types from Raven DataFrames are mapped to the
corresponding R types. More specifically, all integer types
(byte, short, int, long) are mapped to the R 'integer' type. The floating
point types (float, double) are mapped to the R 'double' type. Both string
and char types are mapped to the R 'character' type. Booleans are mapped to
the R 'logical' type. Binary columns are represented as R 'list' types
containing raw vectors.
}
\examples{
\dontrun{
# deserialize a raw vector representing a DataFrame
df <- deserializeDataFrame(my.raw.vector)

# get the types for all columns
types <- sapply(df, typeof)
}

}
\seealso{
\code{\link[=readDataFrame]{readDataFrame()}} for reading DataFrame (.df)
files directly.
}
