% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{writeDataFrame}
\alias{writeDataFrame}
\title{Writes the specified data.frame to the specified file.}
\usage{
writeDataFrame(filepath, df, types = NULL, as.nullable = FALSE)
}
\arguments{
\item{filepath}{The path to the file to write}

\item{df}{The data.frame object to write}

\item{types}{The type names for all column types. Must be a vector of
character values. May be NULL}

\item{as.nullable}{A logical indicating whether the data.frame should
be persisted as a NullableDataFrame, even if it contains no NA values}
}
\value{
The number of bytes written to the specified file
}
\description{
The R data.frame is persisted as a DataFrame (.df) file. The concrete column
types to use for each individual data.frame column can be specified by
the 'types' argument.
}
\details{
The column types of the R data.frame object are mapped to the corresponding
Raven DataFrame column types. The following types exist:

\tabular{ll}{
\strong{Type name} \tab \strong{Description} \cr
byte \tab int8 \cr
short \tab int16 \cr
int \tab int32 \cr
long \tab int64 \cr
float \tab float32 \cr
double \tab float64 \cr
string \tab UTF-8 encoded unicode string \cr
char \tab single printable ASCII character \cr
boolean \tab logical value TRUE or FALSE \cr
binary \tab arbitrary length byte array \cr
}

By default, if the 'types' argument is not explicitly specified, all values
are mapped to the corresponding largest possible type in order to avoid
possible loss of information. However, users can specify the concrete type
for each column in the DataFrame file to be written. This is done by
providing a vector of character values denoting the type name of each
corresponding data.frame column. The index of each entry corresponds to the
index of the column in the underlying data.frame to persist.

If the specified data.frame object contains at least one NA value, then the
DataFrame file to be persisted will represent a NullableDataFrame. If the
data.frame contains no NA values, then the DataFrame file to be persisted
will represent a DefaultDataFrame, unless the 'as.nullable' argument is
set to TRUE.
}
\examples{
\dontrun{
# get a data.frame
df <- cars
# write the data.frame to a .df file
writeDataFrame("cars.df", df)

# specify the concrete types of all columns
coltypes <- c("float", "double")
# write the data.frame to a .df file with concrete types
writeDataFrame("cars.df", df, types = coltypes)
}

}
\seealso{
\code{\link[=serializeDataFrame]{serializeDataFrame()}} for serializing data.frame objects
to vectors of raw bytes. \cr
\code{\link[=readDataFrame]{readDataFrame()}} for reading DataFrame files which have been
previously persisted by this function.
}
