% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_text_image.R
\name{render_text_image}
\alias{render_text_image}
\title{Generate Text Image}
\usage{
render_text_image(
  text,
  lineheight = 1,
  color = "black",
  size = 12,
  font = "sans",
  just = "left",
  background_color = "white",
  background_alpha = 1,
  use_ragg = TRUE,
  width = NA,
  height = NA,
  filename = NULL,
  check_text_width = TRUE,
  check_text_height = TRUE,
  preview = FALSE
)
}
\arguments{
\item{text}{Text to turn into an image.}

\item{lineheight}{Default \code{1}. Multiplier for the lineheight.}

\item{color}{Default \code{"black"}. String specifying the color of the text.}

\item{size}{Default \code{12}. Numeric value specifying the font size of the text.}

\item{font}{Default \code{"sans"}. String specifying the font family for the text.
Common options include \code{"sans"}, \code{"mono"}, \code{"serif"}, \code{"Times"}, \code{"Helvetica"}, etc.}

\item{just}{Default \code{"left"}. Horizontal alignment of the text: \code{"left"},
\code{"center"}, or \code{"right"}.}

\item{background_color}{Default \code{"white"}. Color of the background.}

\item{background_alpha}{Default \code{1}. Transparency of the background. A value
between \code{0} (fully transparent) and \code{1} (fully opaque).}

\item{use_ragg}{Default \code{TRUE}. Whether to use the \code{ragg} package as the graphics device. Required for emojis.}

\item{width}{Default \code{NA}. User-defined textbox width.}

\item{height}{Default \code{NA}. User-defined textbox width.}

\item{filename}{Default \code{NULL}. String specifying the file path to save the resulting image.
If \code{NULL} and \code{preview = FALSE}, the function returns the processed RGB array.}

\item{check_text_width}{Default \code{TRUE}. Whether to manually adjust the bounding
box of the resulting image to ensure the string bbox is wide enough for the text.
Not all systems provide accurate font sizes: this ensures the string is not cut off
at the edges, at the cost of needing to repeatedly render the image internally until
a suitable image is found.}

\item{check_text_height}{Default \code{FALSE}. Whether to manually adjust the bounding
box of the resulting image to ensure the string bbox is tall enough for the text.
This will ensure a tight vertical bounding box on the text.}

\item{preview}{Default \code{FALSE}. Boolean indicating whether to display the image after processing.
If \code{TRUE}, the image is displayed but not saved or returned.}
}
\value{
A 3-layer RGB array of the processed image if \code{filename = NULL} and \code{preview = FALSE}.
Otherwise, writes the image to the specified file or displays it if \code{preview = TRUE}.
}
\description{
Generates an image which tightly fits text.
}
\examples{
if (run_documentation()) {
  #Generate an image of some text
  render_text_image("Some text", preview = TRUE)
}
if (run_documentation()) {
  #Change the font size
  render_text_image("Some text", size = 100, preview = TRUE)
}
if (run_documentation()) {
  #Change the font color
  render_text_image("Some text", size = 100, color="red",preview = TRUE)
}
if (run_documentation()) {
  #Change the background color and transparency
  render_text_image("Some text", size = 50, color="purple",
                      background_color="purple", background_alpha = 0.5,
                      preview = TRUE)
}
if (run_documentation()) {
  # Plot an emoji with the agg device.
  render_text_image("\U0001F600\U0001F680", size = 50, color = "purple", use_ragg = TRUE,
                    background_alpha = 0,
                    preview = TRUE)
}

if (run_documentation()) {
  # Plot an emoji with the agg device and adjust the height and width (which
  # is on by default) to be a tight fit.
  render_text_image("\U0001F600\U0001F680", size = 50, color = "purple", use_ragg = TRUE,
                    background_alpha = 0, check_text_width = TRUE,
                    check_text_height = TRUE,
                    preview = TRUE)
}
}
