% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockchainRpcs.R
\name{verifychain}
\alias{verifychain}
\title{RPC-JSON API: verifychain}
\usage{
verifychain(con, checklevel = NULL, nblocks = NULL)
}
\arguments{
\item{con}{object of class \code{CONRPC}.}

\item{checklevel}{\code{integer} (optional, 0-4, default=3),
how thorough the block verification is.}

\item{nblocks}{\code{integer} (optional, default=6, 0=all),
the number of blocks to check.}
}
\value{
A S4-object of class \code{ANSRPC}.
}
\description{
Verifies blockchain database.
}
\references{
\url{https://bitcoin.org/en/developer-reference#verifychain},
\url{https://bitcoin.org/en/developer-reference#remote-procedure-calls-rpcs}
}
\seealso{
Other Blockchain RPCs: 
\code{\link{decodescript}()},
\code{\link{getbestblockhash}()},
\code{\link{getblock}()},
\code{\link{getblockchaininfo}()},
\code{\link{getblockcount}()},
\code{\link{getblockhash}()},
\code{\link{getblockheader}()},
\code{\link{getchaintips}()},
\code{\link{getchaintxstats}()},
\code{\link{getdifficulty}()},
\code{\link{getmempoolancestors}()},
\code{\link{getmempooldescendants}()},
\code{\link{getmempoolentry}()},
\code{\link{getmempoolinfo}()},
\code{\link{getrawmempool}()},
\code{\link{gettxout}()},
\code{\link{gettxoutproof}()},
\code{\link{gettxoutsetinfo}()},
\code{\link{pruneblockchain}()},
\code{\link{verifytxoutproof}()}
}
\author{
Bernhard Pfaff
}
\concept{Blockchain RPCs}
