% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.r
\name{convert_to}
\alias{convert_to}
\alias{convert_to_SE}
\alias{convert_to_TSE}
\alias{convert_to_phyloseq}
\title{Convert biom data to an external package class.}
\usage{
convert_to_SE(biom, ...)

convert_to_TSE(biom, ...)

convert_to_phyloseq(biom, ...)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{...}{Not Used.}
}
\value{
A phyloseq, SummarizedExperiment, or TreeSummarizedExperiment object.
}
\description{
Requires the relevant Bioconductor R package to be installed:
\describe{
\item{\code{convert_to_phyloseq} - }{ \href{https://bioconductor.org/packages/phyloseq/}{phyloseq} }
\item{\code{convert_to_SE} - }{ \href{https://bioconductor.org/packages/SummarizedExperiment/}{SummarizedExperiment} }
\item{\code{convert_to_TSE} - }{ \href{https://bioconductor.org/packages/TreeSummarizedExperiment/}{TreeSummarizedExperiment} }
}
}
\details{
A SummarizedExperiment object includes counts, metadata, and taxonomy.

phyloseq and TreeSummarizedExperiment additionally includes the tree and sequences.
}
\examples{
\dontrun{
    library(rbiom)

    print(hmp50)

    # Requires 'phyloseq', a Bioconductor R package
    if (nzchar(system.file(package = "phyloseq"))) {
      physeq <- convert_to_phyloseq(hmp50)
      print(physeq)
    }

    # Requires 'SummarizedExperiment', a Bioconductor R package
    if (nzchar(system.file(package = "SummarizedExperiment"))) {
      se <- convert_to_SE(hmp50)
      print(se)
    }

    # Requires 'TreeSummarizedExperiment', a Bioconductor R package
    if (nzchar(system.file(package = "TreeSummarizedExperiment"))) {
      tse <- convert_to_TSE(hmp50)
      print(tse)
    }
}
}
