% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockchainRpcs.R
\name{gettxout}
\alias{gettxout}
\title{RPC-JSON API: gettxout}
\usage{
gettxout(con, txid, n, incmempool = TRUE)
}
\arguments{
\item{con}{object of class \code{CONRPC}.}

\item{txid}{\code{charcater} the transaction id.}

\item{n}{\code{integer} vout number.}

\item{incmempool}{\code{logical} whether to include the mempool (default \code{TRUE}).}
}
\value{
A S4-object of class \code{ANSRPC}.
}
\description{
Returns details about an unspent transaction output.
}
\details{
Note that an unspent output that is spent in the mempool won't appear.
}
\references{
\url{https://bitcoin.org/en/developer-reference#gettxout},
\url{https://bitcoin.org/en/developer-reference#remote-procedure-calls-rpcs}
}
\seealso{
Other Blockchain RPCs: \code{\link{decodescript}},
  \code{\link{getbestblockhash}},
  \code{\link{getblockchaininfo}},
  \code{\link{getblockcount}}, \code{\link{getblockhash}},
  \code{\link{getblockheader}}, \code{\link{getblock}},
  \code{\link{getchaintips}},
  \code{\link{getchaintxstats}},
  \code{\link{getdifficulty}},
  \code{\link{getmempoolancestors}},
  \code{\link{getmempooldescendants}},
  \code{\link{getmempoolentry}},
  \code{\link{getmempoolinfo}},
  \code{\link{getrawmempool}}, \code{\link{gettxoutproof}},
  \code{\link{gettxoutsetinfo}},
  \code{\link{preciousblock}},
  \code{\link{pruneblockchain}}, \code{\link{verifychain}},
  \code{\link{verifytxoutproof}}
}
\author{
Bernhard Pfaff
}
\concept{Blockchain RPCs}
