% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{sampleDates}
\alias{sampleDates}
\title{Sample random calendar dates}
\usage{
sampleDates(x, bins = NA, nsim, boot = FALSE, verbose = TRUE)
}
\arguments{
\item{x}{A 'CalDates' class object.}

\item{bins}{A vector containing the bin names associated with each radiocarbon date. If set to NA, binning is not carried out.}

\item{nsim}{Number of sampling repetitions.}

\item{boot}{A logical value indicating whether bootstrapping is carried out (see details below). Default is FALSE.}

\item{verbose}{A logical variable indicating whether extra information on progress should be reported. Default is TRUE.}
}
\value{
An object of class \code{simdates} with the following elements
\itemize{
\item \code{sdates} A matrix containing the randomly sampled calendar dates, with rows containing each of the \code{nsim} repetitions.
\item \code{weight} A vector (or matrix in when \code{boot=TRUE}) containing the total area under the curve of each date, normalised to sum to unity. Notice this will be identical for all dates if the calibration is carried out with the argument \code{normalised} set to TRUE.
}
}
\description{
Randomly samples calendar dates from each calibrated date or bin.
}
\details{
The function randomly samples calendar dates based from calibrated probability distributions. When the \code{bins} argument is supplied a single calendar date is sampled from each bin. When \code{boot=TRUE}, dates (or bins) are randomly sampled with replacement before calendar dates are sampled.
}
