/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import javax.vecmath.Vector3d;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.ICrystal;

public class Crystal
extends AtomContainer
implements Serializable,
ICrystal,
Cloneable {
    private static final long serialVersionUID = 5919649450390509278L;
    private Vector3d aAxis;
    private Vector3d bAxis;
    private Vector3d cAxis;
    private Integer zValue = 1;
    private String spaceGroup = "P1";

    public Crystal() {
        this.setZeroAxes();
    }

    public Crystal(IAtomContainer container) {
        super(container);
        this.setZeroAxes();
    }

    public void setA(Vector3d newAxis) {
        this.aAxis = newAxis;
        this.notifyChanged();
    }

    public Vector3d getA() {
        return this.aAxis;
    }

    public void setB(Vector3d newAxis) {
        this.bAxis = newAxis;
        this.notifyChanged();
    }

    public Vector3d getB() {
        return this.bAxis;
    }

    public void setC(Vector3d newAxis) {
        this.cAxis = newAxis;
        this.notifyChanged();
    }

    public Vector3d getC() {
        return this.cAxis;
    }

    public String getSpaceGroup() {
        return this.spaceGroup;
    }

    public void setSpaceGroup(String group) {
        this.spaceGroup = group;
        this.notifyChanged();
    }

    public Integer getZ() {
        return this.zValue;
    }

    public void setZ(Integer value) {
        this.zValue = value;
        this.notifyChanged();
    }

    public ICrystal clone() throws CloneNotSupportedException {
        Crystal clone = (Crystal)super.clone();
        clone.setA(new Vector3d(this.aAxis));
        clone.setB(new Vector3d(this.bAxis));
        clone.setC(new Vector3d(this.cAxis));
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder resultString = new StringBuilder(64);
        resultString.append("Crystal(").append(this.hashCode());
        if (this.getSpaceGroup() != null) {
            resultString.append(", SG=").append(this.getSpaceGroup());
        }
        if (this.getZ() > 0) {
            resultString.append(", Z=").append(this.getZ());
        }
        if (this.getA() != null) {
            resultString.append(", a=(").append(this.aAxis.x).append(", ").append(this.aAxis.y).append(", ").append(this.aAxis.z);
        }
        if (this.getB() != null) {
            resultString.append("), b=(").append(this.bAxis.x).append(", ").append(this.bAxis.y).append(", ").append(this.bAxis.z);
        }
        if (this.getC() != null) {
            resultString.append("), c=(").append(this.cAxis.x).append(", ").append(this.cAxis.y).append(", ").append(this.cAxis.z);
        }
        resultString.append(", ").append(super.toString());
        return resultString.toString();
    }

    private void setZeroAxes() {
        this.aAxis = new Vector3d(0.0, 0.0, 0.0);
        this.bAxis = new Vector3d(0.0, 0.0, 0.0);
        this.cAxis = new Vector3d(0.0, 0.0, 0.0);
    }
}

