% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiVDA.r
\name{multiVDA}
\alias{multiVDA}
\title{Pairwise Vargha and Delaney's A and Cliff's delta}
\usage{
multiVDA(
  formula = NULL,
  data = NULL,
  x = NULL,
  g = NULL,
  statistic = "VDA",
  digits = 3,
  ...
)
}
\arguments{
\item{formula}{A formula indicating the response variable and
the independent variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{If no formula is given, the response variable.}

\item{g}{If no formula is given, the grouping variable.}

\item{statistic}{One of \code{"VDA"}, \code{"CD"}, or \code{"rg"}.
This determines which statistic will be
evaluated to determine the comparison with the
most divergent groups.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments passed to the \code{wilcox.test} function.}
}
\value{
A list containing a data frame of pairwise statistics,
        and the comparison with the most extreme value
        of the chosen statistic.
}
\description{
Calculates Vargha and Delaney's A (VDA),
             Cliff's delta (CD), 
             and the Glass rank biserial coefficient, rg,
             for several groups in a pairwise manner.
}
\details{
VDA and CD are effect size statistic appropriate
         in cases where a Wilcoxon-Mann-Whitney test might be used.
         Here, the pairwise approach would be used in cases where
         a Kruskal-Wallis test might be used.
         VDA ranges from 0 to 1, 
         with 0.5 indicating stochastic equality,
         and 1 indicating that the first group dominates the second.
         CD ranges from -1 to 1, with 0 indicating stochastic equality,
         and 1 indicating that the first group dominates the second.
         rg ranges from -1 to 1, 
         depending on sample size,
         with 0 indicating no effect,
         and a positive result indicating
         that values in the first group are greater than in the second.
         
         Be cautious with this interpretation, as R will alphabetize
         groups in the formula interface if the grouping variable
         is not already a factor.
                   
         In the function output,
         \code{VDA.m} is the greater of VDA or 1-VDA.
         \code{CD.m} is the absolute value of CD.
         \code{rg.m} is the absolute value of rg.
         
         The function calculates VDA and Cliff's delta from the "W" 
         U statistic from the
         \code{wilcox.test} function.
         Specifically, \code{VDA = U/(n1*n2); CD = (VDA-0.5)*2}.
         
         rg  is calculated as 2 times the difference of mean of ranks
          for each group divided by the total sample size.
          It appears that rg is equivalent to Cliff's delta.
           
         The input should include either \code{formula} and \code{data};
         or \code{var}, and \code{group}.
         
          Currently, the function makes no provisions for \code{NA}
          values in the data.  It is recommended that \code{NA}s be removed
          beforehand.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
}
\examples{
data(PoohPiglet)
multiVDA(Likert ~ Speaker, data=PoohPiglet)

}
\references{
\url{https://rcompanion.org/handbook/F_08.html}
}
\seealso{
\code{\link{vda}}, 
         \code{\link{cliffDelta}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Cliff's delta}
\concept{Glass rank biserial correlation}
\concept{Kruskal-Wallis}
\concept{Vargha and Delaney's A}
\concept{effect size}
