# rconf

**rconf** is a minimal and lightweight configuration tool for R that supports reading basic YAML configuration files without any additional package dependencies. It is designed for quick prototypes and lightweight projects, such as proteomics data analysis pipelines.

## Features

- Parse basic YAML configuration files
- No external dependencies
- Easy-to-use API for loading and accessing configuration settings

## Installation

```r
install.packages("rconf")
```

## Usage
Place your YAML configuration file in a convenient location. For example, the package includes a sample configuration file in the inst/extdata/ directory. You can load it as follows:

```r
# Load the rconf package
library(rconf)

# Load configuration from the sample file in extdata
cfg <- get_config(system.file("extdata", "config.yml", package = "rconf"))

# Access configuration settings
raw_dir         <- cfg$raw_data_dir
processed_dir   <- cfg$processed_data_dir
metadata_file   <- cfg$sample_metadata
normalization   <- cfg$normalization_method
fdr_cutoff      <- cfg$protein_fdr

# Print values
print(raw_dir)
print(processed_dir)
print(metadata_file)
print(normalization)
print(fdr_cutoff)

```
## Sample Configuration File
The sample YAML configuration file included with rconf (located at inst/extdata/config.yml) is designed for a proteomics data analysis project. It might look like this:

```yaml
default:
  # Data directories and files
  raw_data_dir: "/data/proteomics/raw"
  processed_data_dir: "/data/proteomics/processed"
  sample_metadata: "/data/proteomics/metadata/samples.csv"

  # Analysis parameters
  normalization_method: "median"
  quantification: "LFQ"
  protein_fdr: 0.01

  # Statistical analysis options
  differential_expression: true
  p_value_cutoff: 0.05

  # Plotting options
  plot:
    output_dir: "results/plots"
    format: "png"
    dpi: 300
```

## Unit Testing
The package includes unit tests (using testthat) to ensure that YAML configurations are parsed correctly. See the tests in the tests/testthat/ directory for examples.

## License
GPL-3
