% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{set_rdhs_config}
\alias{set_rdhs_config}
\title{Set rdhs config}
\usage{
set_rdhs_config(
  email = NULL,
  project = NULL,
  cache_path = NULL,
  config_path = NULL,
  global = TRUE,
  verbose_download = FALSE,
  verbose_setup = TRUE,
  data_frame = NULL,
  timeout = 30,
  password_prompt = FALSE,
  prompt = TRUE
)
}
\arguments{
\item{email}{Character for email used to login to the DHS website.}

\item{project}{Character for the name of the DHS project from which
datasets should be downloaded.}

\item{cache_path}{Character for directory path where datasets and API calls
will be cached. If left bank, a suitable directory will be created within
your user cache directory for your operating system (permission granting).}

\item{config_path}{Character for where the config file should be saved.
For a global configuration, `config_path` must be '~/.rdhs.json'.
For a local configuration, `config_path` must be 'rdhs.json'.
If left bank, the config file will be stored within
your user cache directory for your operating system (permission granting).}

\item{global}{Logical for the config_path to be interpreted as a global
config path or a local one. Default = TRUE.}

\item{verbose_download}{Logical for dataset download progress bars to be
shown. Default = FALSE.}

\item{verbose_setup}{Logical for rdhs setup and messages to be printed.
Default = TRUE.}

\item{data_frame}{Function with which to convert API calls into. If left
blank \code{data_frame} objects are returned. Must be passed as a
character. Examples could be:
\code{data.table::as.data.table}
\code{tibble::as.tibble}}

\item{timeout}{Numeric for how long in seconds to wait for the DHS API to
respond. Default = 30.}

\item{password_prompt}{Logical whether user is asked to type their password,
even if they have previously set it. Default = FALSE. Set to TRUE if you
have mistyped your password when using \code{set_rdhs_config}.}

\item{prompt}{Logical for whether the user should be prompted for
permission to write to files. This should not need be
changed by the user. Default = TRUE.}
}
\value{
Invisibly returns the rdhs config object
}
\description{
Sets the configuration settings for using rdhs.
}
\details{
Setting up a configuration will enable API results to be cached, as
  well as enabling datasets from the DHS website to be downloaded and also
  cached. To enable results to be cached you have to either provide a valid
  `cache_path` argument, or allow rdhs to write to the user cache directory
  for your operating system. To do the later, leave the `cache_path` argument
  blank and you will be explicitly prompted to give permission to `rdhs` to
  save your results in this directory. If you do not then your API calls and
  any downloaded datasets will be saved in the temp directory and deleted
  after your R session closes. To allow `rdhs` to download datasets from the
  DHS website, you have to provide both an `email` and `project` argument.
  You will then be prompted to type in your login password securely.
  Your provided config (email, project, password, cache_path etc) will be
  saved at the location provided by `config_path`. If no argument is provided
  `config_path` will be either set to within your user cache directory if you
  have given permission to do so, otherwise it will be placed within your
  temp directory.

  When creating your config you also have the option to specify whether the
  `config_path` provided should be used as a local configuration or a global
  one. This is controlled using the `global` argument, which by default is
  set equal to `TRUE`. A global config is saved within your R root directory
  (the directory that a new R session will start in). If you set `global` to
  `FALSE` the config file will be saved within the current directory. This
  can be useful if you create a new DHS project for each new piece of work,
  and want to keep the datasets you download for this project separate to
  another. If you want to have your config file saved in a different
  directory, then you must create a file "rdhs.json" first in that directory
  before specifying the full path to it, as well as setting `global` equal to
  `FALSE`.

  As an aside, it is useful for the DHS program to see how the surveys they
  conducted are being used, and thus it is helpful for them if you do create
  a new project for each new piece of work (e.g. a different publication).
  However, we would still recommend setting up a global config and using
  the same `cache_path` for different projects as this will save you time
  downloading the same datasets as you have downloaded before.

  Lastly, you can decide how API calls from the DHS API are formatted by
  providing an argument for `data_frame`. If left blank API calls will be
  returned as `data.frame` objects, however, you could return API calls as
  `data.table` objects using `data.table::as.data.table`.
}
\examples{

\dontrun{
# normal set up we would prvide the email and project, and be prompted for
# the password. (not run as it requires a prompt)
set_rdhs_config(email = "blah@gmail.com", project = "Blahs",
config_path = "rdhs.json", global = FALSE)


# otherwise we can do this by specifying prompt to FALSE
set_rdhs_config(
config_path = "rdhs.json", global = FALSE, prompt = FALSE
)

# you can look at what you have set these to using \code{get_rdhs_config}
config <- get_rdhs_config()
}


}
