% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRDI.R
\name{rdiAxis}
\alias{rdiAxis}
\title{RDI Axis annotation function}
\usage{
rdiAxis(model, side = 2, at = NULL, ...)
}
\arguments{
\item{model}{A model object, as generated by \link{rdiModel}.}

\item{side}{The side the axis will be added to. (1 - bottom; 2 - left; 3 - top;
4 - right). Default is 2.}

\item{at}{The points at which the tick marks are drawn. By default, 
tickmarks are placed at 'round' fold/percent change values
using the "\link[base]{pretty}" breakpoints function. This may
not be ideal if log-RDI values are being plotted.}

\item{...}{Additional parameters to pass to \link[graphics]{axis}}
}
\description{
This function takes a RDI model, as generated by \link{rdiModel}, 
  and adds an axis with annotations in the fold change space.
}
\details{
This function is designed to replace the default axes generated by a plot 
function. Instead of annotating the true RDI value, \code{rdiAxis} will estimate
the "true difference" values at various points within the plotting region, and will
annotate the axis with those estimates. 

It is worth noting that although the RDI value can range below \code{rdiModel}'s 
estimate for "identical" repertoires, no negative true difference values will be 
annotated, as these values do not make sense.
}
\examples{

#create genes
genes = sample(letters, 10000, replace=TRUE)
#create sequence annotations
seqAnnot = data.frame(donor = sample(1:10, 10000, replace=TRUE))
#calculate RDI
d = rdi(genes, seqAnnot)

##create a "baseVect" with the same probability as our features
##since we sampled uniformly, the base vector has equal probability
baseVect = rep(1/length(letters),length(letters))

##generate an RDI model
m = rdiModel(attr(d, "nseq"), baseVects=baseVect)

##convert RDI to lfc
td = convertRDI(d,models=m)$pred

par(mar=c(4,4,1,4),las=1,mgp=c(3,0.5,0))
plot(td,d, ylab="RDI", xlab="LFC")

##now add "true difference" axis annotation to the right side of the plot
rdiAxis(m, side=4)

}
\seealso{
\link{rdiModel}, \link{rdiLadder}, \link{plotRDIladder}
}
