% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4-0-0rdesimate.R
\name{rdestimate}
\alias{rdestimate}
\title{RD Estimate Function}
\usage{
rdestimate(y, x, c, group_name = NULL, data)
}
\arguments{
\item{y}{A character string specifying the name of column containing the
outcome variable.}

\item{x}{A character string specifying the name of column containing the
running variable.}

\item{c}{A character string specifying the name of column containing the
cutoff variable.}

\item{group_name}{A character ctring specifying the name of the column
containing group names (e.g., department names) for each cutoff. If not
provided, the groups are assigned names "Group 1", "Group 2", ... in
ascending order of cutoff values.}

\item{data}{A data frame containing all required variables.}
}
\value{
A data frame with the RD estimates for each group, including the
  sample size of each group, baseline cutoff, RD estimate, standard error,
  and p-value.
}
\description{
This function estimates local causal effect of treatment under standard
regression discontinuity (RD) setting.
}
\examples{
rdestimate_result <- rdestimate(
  y = "elig", x = "saber11", c = "cutoff",
  group_name = "department", data = acces
)
print(rdestimate_result)
}
