% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_load.r
\name{compute_load}
\alias{compute_load}
\title{Compute load with uncertainty on concentration estimates}
\usage{
compute_load(Surrogate, Discharge, Regression, period = NULL)
}
\arguments{
\item{Surrogate}{data frame with time (PosixCt) and surrogate(s) (x,...)}

\item{Discharge}{data frame with time (PosixCt) and discharge in cubic meters per second}

\item{Regression}{data frame from bootstrap_regression() that determines analyte(surrogate)}

\item{period}{two element vector time (PosixCt) indicating period over which load is computed}
}
\value{
list with data frames of estimated concentration and flux used to compute load (i.e., the sum of flux)
}
\description{
Compute load with uncertainty on concentration estimates from bootstrap regression after Rustomji and Wilkinson (2008)
}
\section{Note}{

Surrogate and Discharge time series can be on different time steps

If period is NULL, computes load over time in Surrogate
}

\section{Warning}{

Discharge should be in cubic meters per second

Analyte concentration estimated from surrogate should be in milligrams per second
}

\examples{
\donttest{
Turbidity_FNU <- realTimeloads::ExampleData$Sonde$Turbidity
TSS_mg_per_l <- realTimeloads::ExampleData$Sediment_Samples$SSCpt_mg_per_liter
Discharge <- realTimeloads::ExampleData$Discharge
Calibration <- data.frame(Turbidity_FNU,TSS_mg_per_l)
time <- realTimeloads::ExampleData$Sonde$time
Surrogate <- data.frame(time,Turbidity_FNU)
Regression = bootstrap_regression(Calibration,'TSS_mg_per_l~Turbidity_FNU')
period <- c(as.POSIXct("2000-02-16 AEST"),as.POSIXct("2000-03-16 AEST"))
Output <- compute_load(Surrogate,Discharge,Regression,period)
}
}
\references{
Rustomji, P., & Wilkinson, S. N. (2008). Applying bootstrap resampling to quantify uncertainty in fluvial suspended sediment loads estimated using rating curves. Water resources research, 44(9).https://doi.org/10.1029/2007WR006088

Helsel, D.R., Hirsch, R.M., Ryberg, K.R., Archfield, S.A., and Gilroy, E.J., 2020, #' Statistical methods in water resources: U.S. Geological Survey Techniques and Methods, book 4, chap. A3, 458 p. https://doi.org/10.3133/tm4a3
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
