% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_stresses.R
\name{rl_stresses}
\alias{rl_stresses}
\title{IUCN Red List stress categories}
\usage{
rl_stresses(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{code}{Character or Numeric. One or more stress codes (e.g., "1", "2_1").
Use \code{\link[=rl_stresses]{rl_stresses()}} to list available stress categories.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) containing stress categories or species assessments.
If \code{code = NULL}, the tibble contains available stress categories with columns such as code and description.
If \code{code} is provided, the tibble contains assessment data for the specified stress(es), including year, taxon details,
and other relevant metadata.
}
\description{
Retrieve species assessments based on stress categories affecting species.
If \code{code = NULL}, it returns a list of available stress categories.
If \code{code} is provided, it retrieves assessments for species affected by the specified stress(es).
}
\examples{
\dontrun{
# List all stress categories
rl_stresses()

# Get species affected by ecosystem stresses (code 1)
rl_stresses(code = "1") # or code = 1

# Get species affected by competition stresses published since 2020
rl_stresses(
  code = "2_3_2",
  year_published = 2020:2023
)
}
}
