% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{getEnv}
\alias{getEnv}
\alias{setEnv}
\title{Extract or Set Reference Environment}
\usage{
getEnv(x)

setEnv(x, e)
}
\arguments{
\item{x}{object of class \code{"ref"} or \code{"sref"}}

\item{e}{new environment to which the reference points}
}
\value{
environment for \code{getEnv} or reference object for \code{setEnv}
}
\description{
Functions to obtain or set the environment to which a \code{\link{ref}} or \code{\link{sref}} object points.
}
\examples{
x <- 1:10
ref_to_x <- ref(x)
ref_env  <- getEnv(ref_to_x)
ref_sym  <- getSym(ref_to_x)

identical(ref_env, .GlobalEnv)
identical(ref_sym, "x")

e <- new.env()
e$x <- 100
ref_to_x <- setEnv(ref_to_x, e)
!ref_to_x

}
