% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sref.R
\name{sref}
\alias{sref}
\title{Create a Safer Reference to an Object}
\usage{
sref(x)
}
\arguments{
\item{x}{object to be referenced. \code{x} can be a symbol, character, or an expression containing a symbol.}
}
\description{
Create a reference to an arbitrary R object. See \code{\link{ref}} for more details. \code{sref} behaves
similar to \code{ref}, but does not have support for direct operations on the referenced object.
}
\details{
\code{sref} is similar to \code{\link{ref}}; it accepts either an R object or an expression, then records
its location. \code{ref} objects prioritize convenience, while \code{sref} objects prioritize clarity and
safety. For example, \code{`[`} and \code{`$`} can be used on a \code{ref} object to access the elements
of the underlying object, while \code{`[<-`} and \code{`$<-`} can be used to overwrite elements within.
These do not work for \code{sref} objects. Furthermore, base mathematical functions such as \code{`+`}
and \code{sqrt} also will not automatically dereference before applying.
}
\examples{
x <- 1:10
ref_x  <- ref(x)
sref_x <- sref(x)

## These operations will run:
ref_x + 5
ref_x[1:4]
ref_x[7] <- 5

## These operations will not run:
# sref_x + 5
# sref_x[1:4]
# sref_x[7] <- 5

}
