% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_bathrooms.R
\name{rfg_all_restrooms}
\alias{rfg_all_restrooms}
\title{All refuge restrooms}
\usage{
rfg_all_restrooms(
  accessible = FALSE,
  unisex = FALSE,
  verbose = TRUE,
  tidy = FALSE
)
}
\arguments{
\item{accessible}{If \code{TRUE}, only returns restrooms that meet the
Americans with Disability Act standards for accessibility.
Defaults to \code{FALSE}.}

\item{unisex}{If \code{TRUE}, only returns unisex restrooms.
Defaults to \code{FALSE}.}

\item{verbose}{If \code{TRUE}, prints query progress.
Defaults to \code{TRUE}.}

\item{tidy}{If \code{TRUE}, makes USA state names more consistent. The internal
function focuses on correcting known errors and mistakes, if incorrect state
data is supplied that cannot be corrected. Defaults to \code{FALSE}.}
}
\value{
A tibble with details on all listed bathrooms.
}
\description{
All listed refuge restrooms, ordered by date added or last updated, with
the most recent additions and updates at the top.
}
\details{
Note that the API does not standardise or validate the names of
states, cities, countries, etc, and so this data may need to be cleaned
and organised.
}
\examples{
\dontrun{
a <- rfg_all_restrooms(accessible = TRUE, unisex = TRUE)
}

}
