% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_rga3h.R
\name{ga3h}
\alias{ga3h}
\title{Graphical approach for three hypotheses}
\usage{
ga3h(w, G, p, alpha)
}
\arguments{
\item{w}{a vector of initial weights}

\item{G}{a matrix of initial transaction weights}

\item{p}{a vector of p-values}

\item{alpha}{a number of significance level}
}
\value{
a logical vector indicating whether the hypothesis is rejected: TRUE = rejected, FALSE = accepted
}
\description{
Graphical approach for three hypotheses
}
\examples{
w <- c(0.3,0.5,0.2)
G <- matrix(c(0,1/3,2/3, 1/2,0,1/2, 1/5,4/5,0),nrow=3,byrow=TRUE)
p <- c(0.012, 0.051, 0.021)
p <- c(0.012, 0.051, 0.019)
alpha <- 0.05
ga3h(w=w,G=G,p=p, alpha=alpha)

}
\references{
Bretz, F., Maurer, W., Brannath, W., and Posch, M. (2009). A graphical approach to sequentially rejective multiple test procedures. Statistics in Medicine 28, 586–-604. <doi:10.1002/sim.3495>
}
\author{
Jiangtao Gou
}
