% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_rga2pwr.R
\name{rga2pwr}
\alias{rga2pwr}
\title{Power Analysis for Graphical Approaches and Reverse Graphical Approaches with Two Hypotheses}
\usage{
rga2pwr(w, G, alpha, delta, corr, method = "rga")
}
\arguments{
\item{w}{a vector of initial weights}

\item{G}{a matrix of initial transaction weights}

\item{alpha}{a number of significance level}

\item{delta}{a vector of effect sizes}

\item{corr}{a correlation matrix}

\item{method}{a string specified the method: "rga" for Reverse Graphical Approaches and "ga" for Graphical Approaches}
}
\value{
a numerical matrix including the probabilities of four combinations of being rejected and being accepted for two hypotheses. Row indices stand for the first hypothesis, and column indices stand for the second hypothesis. The first index stands for the probability of acceptance, and the second index stands for the probability of rejection.
}
\description{
Power Analysis for Graphical Approaches and Reverse Graphical Approaches with Two Hypotheses
}
\examples{
w <- c(0.3,0.7)
G <- matrix(c(0,1,1,0),nrow=2,byrow=TRUE)
alpha <- 0.05
delta <- c(0,2)
rho <- 0.0
corr <- matrix(c(1,rho,rho,1), nrow=2)
method="rga"
rga2pwr(w=w, G=G, alpha=alpha, delta=delta, corr=corr, method=method)



}
\references{
Bretz, F., Maurer, W., Brannath, W., and Posch, M. (2009). A graphical approach to sequentially rejective multiple test procedures. Statistics in Medicine 28, 586–-604. <doi:10.1002/sim.3495>

Gou, J. (2020). Reverse graphical approaches for multiple test procedures. Technical Report.
}
\author{
Jiangtao Gou
}
