% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcplot.R
\name{mcmcplot}
\alias{mcmcplot}
\title{Visualizing the posterior sample
Creates a set of plots for visually evaluating convergence and mixing of the chains
from the MCMC sample of an object of class 'remiod'.}
\usage{
mcmcplot(object, what = c("trace", "density"), subset = c(analysis_main =
  TRUE), outcome = NULL, mi.setting = NULL, nrow = NULL, ncol = NULL,
  use_ggplot = TRUE, mess = TRUE, warn = FALSE, ...)
}
\arguments{
\item{object}{an object inheriting from class 'remoid'}

\item{what}{select either trace or density plots from MCMC samples}

\item{subset}{subset of parameters/variables/nodes (columns in the MCMC
sample). Follows the same principle as the argument
\code{monitor_params} in
\code{\link[JointAI:model_imp]{*_imp}}.}

\item{outcome}{optional; vector identifying a subset of sub-models included
in the output, either by specifying their indices (using the
order used in the list of model formulas), or their
names (LHS of the respective model formula as character
string)}

\item{mi.setting}{a list of arguments for extracting MI data set, which
will be used to update the one in \code{remoid} object.
Default is NULL, meaning no update to the mi.setting
in \code{remoid} object.}

\item{nrow}{optional; number of rows in the plot layout;
automatically chosen if unspecified}

\item{ncol}{optional; number of columns in the plot layout;
automatically chosen if unspecified}

\item{use_ggplot}{logical; Should ggplot be used instead of the base
graphics?}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}.}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}.}

\item{...}{
  Arguments passed on to \code{\link[graphics:matplot]{graphics::matplot}}
  \describe{
    \item{\code{lty,lwd,lend}}{vector of line types, widths, and end styles.
    The first element is for the first column, the second element for
    the second column, etc., even if lines are not plotted for all
    columns. Line types will be used cyclically until all plots are
    drawn.}
    \item{\code{col}}{vector of colors.  Colors are used cyclically.}
    \item{\code{cex}}{vector of character expansion sizes, used cyclically.
    This works as a multiple of \code{\link[graphics]{par}("cex")}.  \code{NULL} is
    equivalent to \code{1.0}. }
    \item{\code{bg}}{vector of background (fill) colors for the open plot
    symbols given by \code{pch = 21:25} as in \code{\link[graphics]{points}}.  The
    default \code{NA} corresponds to the one of the underlying function
    \code{\link[graphics]{plot.xy}}.}
    \item{\code{add}}{logical.  If \code{TRUE}, plots are added to current one,
    using \code{\link[graphics]{points}} and \code{\link[graphics]{lines}}.}
    \item{\code{verbose}}{logical.  If \code{TRUE}, write one line of what is
    done.}
  }}
}
\value{
plots of traces or densities of MCMC samples for selected parameters in
imputation models.
}
\description{
Visualizing the posterior sample
Creates a set of plots for visually evaluating convergence and mixing of the chains
from the MCMC sample of an object of class 'remiod'.
}
\examples{
\donttest{
# data(schizow)

test = remiod(formula = y6 ~ tx + y0 + y1 + y3, data = schizow,
              trtvar = 'tx', algorithm = 'jags', method="MAR",
              ord_cov_dummy = FALSE, n.adapt = 10, n.chains = 1,
              n.iter = 10, thin = 2, warn = FALSE, seed = 1234)

p1 = mcmcplot(object=test, what="trace")
}

}
