% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-methods.R
\name{lemmy_get_site}
\alias{lemmy_get_site}
\title{Gets the site, and your user data.}
\usage{
lemmy_get_site(
  auth = NULL,
  .lemmy_instance = getOption("lemmy_instance", "https://lemmy.world")
)
}
\arguments{
\item{auth}{(Optional) A character value.}

\item{.lemmy_instance}{Default: "https://lemmy.world". Change the default instance by setting the \code{lemmy_instance} \code{\link[=options]{options()}}.}
}
\value{
A \code{list} of length 8:
\preformatted{<list>
|-site_view: <list>
| |-site: <list>
| | |-id: A numeric value
| | |-name: A character value
| | |-sidebar: (Optional) A character value
| | |-published: A character value
| | |-updated: (Optional) A character value
| | |-icon: (Optional) A character value
| | |-banner: (Optional) A character value
| | |-description: (Optional) A character value
| | |-actor_id: A character value
| | |-last_refreshed_at: A character value
| | |-inbox_url: A character value
| | |-private_key: (Optional) A character value
| | |-public_key: A character value
| | `-instance_id: A numeric value
| |-local_site: <list>
| | |-id: A numeric value
| | |-site_id: A numeric value
| | |-site_setup: A logical value
| | |-enable_downvotes: A logical value
| | |-enable_nsfw: A logical value
| | |-community_creation_admin_only: A logical value
| | |-require_email_verification: A logical value
| | |-application_question: (Optional) A character value
| | |-private_instance: A logical value
| | |-default_theme: A character value
| | |-default_post_listing_type: One of "All", "Local", or "Subsc...
| | |-legal_information: (Optional) A character value
| | |-hide_modlog_mod_names: A logical value
| | |-application_email_admins: A logical value
| | |-slur_filter_regex: (Optional) A character value
| | |-actor_name_max_length: A numeric value
| | |-federation_enabled: A logical value
| | |-captcha_enabled: A logical value
| | |-captcha_difficulty: A character value
| | |-published: A character value
| | |-updated: (Optional) A character value
| | |-registration_mode: One of "Closed", "RequireApplica...
| | `-reports_email_admins: A logical value
| |-local_site_rate_limit: <list>
| | |-id: A numeric value
| | |-local_site_id: A numeric value
| | |-message: A numeric value
| | |-message_per_second: A numeric value
| | |-post: A numeric value
| | |-post_per_second: A numeric value
| | |-register: A numeric value
| | |-register_per_second: A numeric value
| | |-image: A numeric value
| | |-image_per_second: A numeric value
| | |-comment: A numeric value
| | |-comment_per_second: A numeric value
| | |-search: A numeric value
| | |-search_per_second: A numeric value
| | |-published: A character value
| | `-updated: (Optional) A character value
| `-counts: <list>
|   |-id: A numeric value
|   |-site_id: A numeric value
|   |-users: A numeric value
|   |-posts: A numeric value
|   |-comments: A numeric value
|   |-communities: A numeric value
|   |-users_active_day: A numeric value
|   |-users_active_week: A numeric value
|   |-users_active_month: A numeric value
|   `-users_active_half_year: A numeric value
|-admins: <list>
| `-[Each element]: <list>
|   |-person: <list>
|   | |-id: A numeric value
|   | |-name: A character value
|   | |-display_name: (Optional) A character value
|   | |-avatar: (Optional) A character value
|   | |-banned: A logical value
|   | |-published: A character value
|   | |-updated: (Optional) A character value
|   | |-actor_id: A character value
|   | |-bio: (Optional) A character value
|   | |-local: A logical value
|   | |-banner: (Optional) A character value
|   | |-deleted: A logical value
|   | |-inbox_url: A character value
|   | |-matrix_user_id: (Optional) A character value
|   | |-admin: A logical value
|   | |-bot_account: A logical value
|   | |-ban_expires: (Optional) A character value
|   | `-instance_id: A numeric value
|   `-counts: <list>
|     |-id: A numeric value
|     |-person_id: A numeric value
|     |-post_count: A numeric value
|     |-post_score: A numeric value
|     |-comment_count: A numeric value
|     `-comment_score: A numeric value
|-version: A character value
|-my_user: <list>
| |-local_user_view: <list>
| | |-local_user: <list>
| | | |-id: A numeric value
| | | |-person_id: A numeric value
| | | |-email: (Optional) A character value
| | | |-show_nsfw: A logical value
| | | |-theme: A character value
| | | |-default_sort_type: One of "Active", "Hot", "New", "...
| | | |-default_listing_type: One of "All", "Local", or "Subsc...
| | | |-interface_language: A character value
| | | |-show_avatars: A logical value
| | | |-send_notifications_to_email: A logical value
| | | |-validator_time: A character value
| | | |-show_scores: A logical value
| | | |-show_bot_accounts: A logical value
| | | |-show_read_posts: A logical value
| | | |-show_new_post_notifs: A logical value
| | | |-email_verified: A logical value
| | | |-accepted_application: A logical value
| | | |-totp_2fa_url: (Optional) A character value
| | | `-open_links_in_new_tab: A logical value
| | |-person: <list>
| | | |-id: A numeric value
| | | |-name: A character value
| | | |-display_name: (Optional) A character value
| | | |-avatar: (Optional) A character value
| | | |-banned: A logical value
| | | |-published: A character value
| | | |-updated: (Optional) A character value
| | | |-actor_id: A character value
| | | |-bio: (Optional) A character value
| | | |-local: A logical value
| | | |-banner: (Optional) A character value
| | | |-deleted: A logical value
| | | |-inbox_url: A character value
| | | |-matrix_user_id: (Optional) A character value
| | | |-admin: A logical value
| | | |-bot_account: A logical value
| | | |-ban_expires: (Optional) A character value
| | | `-instance_id: A numeric value
| | `-counts: <list>
| |   |-id: A numeric value
| |   |-person_id: A numeric value
| |   |-post_count: A numeric value
| |   |-post_score: A numeric value
| |   |-comment_count: A numeric value
| |   `-comment_score: A numeric value
| |-follows: <list>
| | `-[Each element]: <list>
| |   |-community: <list>
| |   | |-id: A numeric value
| |   | |-name: A character value
| |   | |-title: A character value
| |   | |-description: (Optional) A character value
| |   | |-removed: A logical value
| |   | |-published: A character value
| |   | |-updated: (Optional) A character value
| |   | |-deleted: A logical value
| |   | |-nsfw: A logical value
| |   | |-actor_id: A character value
| |   | |-local: A logical value
| |   | |-icon: (Optional) A character value
| |   | |-banner: (Optional) A character value
| |   | |-followers_url: A character value
| |   | |-inbox_url: A character value
| |   | |-hidden: A logical value
| |   | |-posting_restricted_to_mods: A logical value
| |   | `-instance_id: A numeric value
| |   `-follower: <list>
| |     |-id: A numeric value
| |     |-name: A character value
| |     |-display_name: (Optional) A character value
| |     |-avatar: (Optional) A character value
| |     |-banned: A logical value
| |     |-published: A character value
| |     |-updated: (Optional) A character value
| |     |-actor_id: A character value
| |     |-bio: (Optional) A character value
| |     |-local: A logical value
| |     |-banner: (Optional) A character value
| |     |-deleted: A logical value
| |     |-inbox_url: A character value
| |     |-matrix_user_id: (Optional) A character value
| |     |-admin: A logical value
| |     |-bot_account: A logical value
| |     |-ban_expires: (Optional) A character value
| |     `-instance_id: A numeric value
| |-moderates: <list>
| | `-[Each element]: <list>
| |   |-community: <list>
| |   | |-id: A numeric value
| |   | |-name: A character value
| |   | |-title: A character value
| |   | |-description: (Optional) A character value
| |   | |-removed: A logical value
| |   | |-published: A character value
| |   | |-updated: (Optional) A character value
| |   | |-deleted: A logical value
| |   | |-nsfw: A logical value
| |   | |-actor_id: A character value
| |   | |-local: A logical value
| |   | |-icon: (Optional) A character value
| |   | |-banner: (Optional) A character value
| |   | |-followers_url: A character value
| |   | |-inbox_url: A character value
| |   | |-hidden: A logical value
| |   | |-posting_restricted_to_mods: A logical value
| |   | `-instance_id: A numeric value
| |   `-moderator: <list>
| |     |-id: A numeric value
| |     |-name: A character value
| |     |-display_name: (Optional) A character value
| |     |-avatar: (Optional) A character value
| |     |-banned: A logical value
| |     |-published: A character value
| |     |-updated: (Optional) A character value
| |     |-actor_id: A character value
| |     |-bio: (Optional) A character value
| |     |-local: A logical value
| |     |-banner: (Optional) A character value
| |     |-deleted: A logical value
| |     |-inbox_url: A character value
| |     |-matrix_user_id: (Optional) A character value
| |     |-admin: A logical value
| |     |-bot_account: A logical value
| |     |-ban_expires: (Optional) A character value
| |     `-instance_id: A numeric value
| |-community_blocks: <list>
| | `-[Each element]: <list>
| |   |-person: <list>
| |   | |-id: A numeric value
| |   | |-name: A character value
| |   | |-display_name: (Optional) A character value
| |   | |-avatar: (Optional) A character value
| |   | |-banned: A logical value
| |   | |-published: A character value
| |   | |-updated: (Optional) A character value
| |   | |-actor_id: A character value
| |   | |-bio: (Optional) A character value
| |   | |-local: A logical value
| |   | |-banner: (Optional) A character value
| |   | |-deleted: A logical value
| |   | |-inbox_url: A character value
| |   | |-matrix_user_id: (Optional) A character value
| |   | |-admin: A logical value
| |   | |-bot_account: A logical value
| |   | |-ban_expires: (Optional) A character value
| |   | `-instance_id: A numeric value
| |   `-community: <list>
| |     |-id: A numeric value
| |     |-name: A character value
| |     |-title: A character value
| |     |-description: (Optional) A character value
| |     |-removed: A logical value
| |     |-published: A character value
| |     |-updated: (Optional) A character value
| |     |-deleted: A logical value
| |     |-nsfw: A logical value
| |     |-actor_id: A character value
| |     |-local: A logical value
| |     |-icon: (Optional) A character value
| |     |-banner: (Optional) A character value
| |     |-followers_url: A character value
| |     |-inbox_url: A character value
| |     |-hidden: A logical value
| |     |-posting_restricted_to_mods: A logical value
| |     `-instance_id: A numeric value
| |-person_blocks: <list>
| | `-[Each element]: <list>
| |   |-person: <list>
| |   | |-id: A numeric value
| |   | |-name: A character value
| |   | |-display_name: (Optional) A character value
| |   | |-avatar: (Optional) A character value
| |   | |-banned: A logical value
| |   | |-published: A character value
| |   | |-updated: (Optional) A character value
| |   | |-actor_id: A character value
| |   | |-bio: (Optional) A character value
| |   | |-local: A logical value
| |   | |-banner: (Optional) A character value
| |   | |-deleted: A logical value
| |   | |-inbox_url: A character value
| |   | |-matrix_user_id: (Optional) A character value
| |   | |-admin: A logical value
| |   | |-bot_account: A logical value
| |   | |-ban_expires: (Optional) A character value
| |   | `-instance_id: A numeric value
| |   `-target: <list>
| |     |-id: A numeric value
| |     |-name: A character value
| |     |-display_name: (Optional) A character value
| |     |-avatar: (Optional) A character value
| |     |-banned: A logical value
| |     |-published: A character value
| |     |-updated: (Optional) A character value
| |     |-actor_id: A character value
| |     |-bio: (Optional) A character value
| |     |-local: A logical value
| |     |-banner: (Optional) A character value
| |     |-deleted: A logical value
| |     |-inbox_url: A character value
| |     |-matrix_user_id: (Optional) A character value
| |     |-admin: A logical value
| |     |-bot_account: A logical value
| |     |-ban_expires: (Optional) A character value
| |     `-instance_id: A numeric value
| `-discussion_languages: A numeric vector
|-all_languages: <list>
| `-[Each element]: <list>
|   |-id: A numeric value
|   |-code: A character value
|   `-name: A character value
|-discussion_languages: A numeric vector
|-taglines: <list>
| `-[Each element]: <list>
|   |-id: A numeric value
|   |-local_site_id: A numeric value
|   |-content: A character value
|   |-published: A character value
|   `-updated: (Optional) A character value
`-custom_emojis: <list>
  `-[Each element]: <list>
    |-custom_emoji: <list>
    | |-id: A numeric value
    | |-local_site_id: A numeric value
    | |-shortcode: A character value
    | |-image_url: A character value
    | |-alt_text: A character value
    | |-category: A character value
    | |-published: A character value
    | `-updated: (Optional) A character value
    `-keywords: <list>
      `-[Each element]: <list>
        |-id: A numeric value
        |-custom_emoji_id: A numeric value
        `-keyword: A character value
}
}
\description{
\code{HTTP.GET /site}
}
\examples{
\dontshow{if (remmy:::is_lemmy_world()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
site_data <- lemmy_get_site()

site_data$site_view$site$name

site_data$site_view$counts$users
\dontshow{\}) # examplesIf}
}
