% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial-functions.R
\name{max_dist}
\alias{max_dist}
\title{calculate maximum distance among a table of coordinates}
\usage{
max_dist(coords, dist_FUN = "distm_km")
}
\arguments{
\item{coords}{the coordinate matrix (or dataframe) from which a maximum distance is desired.}

\item{dist_FUN}{the distance function used to calculate distances}
}
\value{
The maximum distance between two points (units determined by
\code{dist_FUN})
}
\description{
calculate maximum distance among a table of coordinates
}
\details{
First the outermost points are found by fitting a convex hull in
Euclidean space. Then, the distances between these outer points is calculated
with \code{dist_FUN}, and the maximum of these distances is returned

This is a fast, simple way of determining the maximum distance.
}
